/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.syntax.RegionList;

public abstract class SectionView {
    protected Section section;
    protected RegionList fromSyntaxHighlightRegions;
    protected RegionList toSyntaxHighlightRegions;

    protected SectionView(Section section) {
        this.section = section;
    }

    public Section getSection() {
        return this.section;
    }

    public abstract CharSequence getFromLine(int var1);

    public abstract CharSequence getToLine(int var1);

    public abstract CharSequence getFromLines();

    public abstract CharSequence getToLines();

    public abstract int getFromLineOffset(int var1);

    public abstract int getToLineOffset(int var1);

    public RegionList getToSyntaxHighlights() {
        return this.toSyntaxHighlightRegions;
    }

    public RegionList getFromSyntaxHighlights() {
        return this.fromSyntaxHighlightRegions;
    }

    public RegionList getToLineSyntaxHighlights(int line) {
        return this.toSyntaxHighlightRegions.getSubset(this.getToLineOffset(line), this.getToLineOffset(line + 1));
    }

    public RegionList getFromLineSyntaxHighlights(int line) {
        return this.fromSyntaxHighlightRegions.getSubset(this.getFromLineOffset(line), this.getFromLineOffset(line + 1));
    }

    protected RegionList getTranslatedSubset(int startOffset, int endOffset, RegionList regions) {
        RegionList subset = regions.getSubset(startOffset, endOffset);
        subset.translate(-startOffset);
        return subset;
    }
}

