/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.EDiff;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.syntax.RegionList;
import java.io.IOException;

public class LinePair {
    private final DiffPrinter printer;
    private final SectionView sectionView;
    private final boolean startOfSection;
    private final boolean startOfSubSection;
    private final Line from;
    private final Line to;
    private EDiff ediff;

    public LinePair(DiffPrinter printer, SectionView sectionView, boolean startOfSection, boolean startOfSubSection, Integer fromLine, Integer toLine) {
        this.printer = printer;
        this.sectionView = sectionView;
        this.startOfSection = startOfSection;
        this.startOfSubSection = startOfSubSection;
        this.from = fromLine == null ? null : new Line(fromLine, true);
        this.to = toLine == null ? null : new Line(toLine, false);
    }

    public SectionView getSectionView() {
        return this.sectionView;
    }

    public Section getSection() {
        return this.sectionView.getSection();
    }

    public String getLineClassString() {
        StringBuilder lineClass = new StringBuilder();
        if (this.from != null) {
            lineClass.append("fromLine from").append(this.from.getLineNumber() + 1);
        }
        if (this.to != null) {
            lineClass.append(" ");
            lineClass.append("toLine to").append(this.to.getLineNumber() + 1);
        }
        return lineClass.toString();
    }

    public String getLineDataAttribute() {
        StringBuilder lineData = new StringBuilder();
        if (this.from != null) {
            lineData.append("data-from=\"").append(this.from.getLineNumber() + 1).append("\"");
        }
        if (this.to != null) {
            lineData.append(" ");
            lineData.append("data-to=\"").append(this.to.getLineNumber() + 1).append("\"");
        }
        return lineData.toString();
    }

    public boolean isStartOfSection() {
        return this.startOfSection;
    }

    public boolean isStartOfSubSection() {
        return this.startOfSubSection;
    }

    public boolean isInFirstSection() {
        return this.sectionView == this.printer.getFirstSectionView();
    }

    public boolean isInLastSection() {
        return this.sectionView == this.printer.getLastSectionView();
    }

    public Line getFrom() {
        return this.from;
    }

    public Line getTo() {
        return this.to;
    }

    public boolean getShowFrom() {
        if (this.printer.isUnified() && this.getSection().isCommonSubsequence()) {
            return false;
        }
        return this.from != null;
    }

    public boolean getShowTo() {
        return this.to != null;
    }

    public boolean getHasEdiff() {
        return this.ediff != null;
    }

    public EDiff getEdiff() {
        return this.ediff;
    }

    void setEdiff(EDiff ediff) {
        this.ediff = ediff;
    }

    public int getFromLineNumberEquiv() {
        boolean isAdd;
        boolean bl = isAdd = this.getSection().isDiff() && this.getSection().getHunk().isAdd();
        return this.from != null ? this.from.getLineNumber() : this.getSection().getFromStart() - (isAdd ? 1 : 0);
    }

    public int getToLineNumberEquiv() {
        boolean isDelete;
        boolean bl = isDelete = this.getSection().isDiff() && this.getSection().getHunk().isDelete();
        return this.to != null ? this.to.getLineNumber() : this.getSection().getToStart() - (isDelete ? 1 : 0);
    }

    public class Line {
        private final int lineNumber;
        private final boolean isFrom;
        private CharSequence line;

        public Line(int lineNumber, boolean from) {
            this.lineNumber = lineNumber;
            this.isFrom = from;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public CharSequence getLine() {
            if (this.line == null) {
                this.line = this.isFrom ? LinePair.this.sectionView.getFromLine(this.lineNumber) : LinePair.this.sectionView.getToLine(this.lineNumber);
            }
            return this.line;
        }

        public boolean isLastLineInSection() {
            Section section = LinePair.this.sectionView.getSection();
            if (this.isFrom) {
                return this.lineNumber == section.getFromStart() + section.getFromLength() - 1;
            }
            return this.lineNumber == section.getToStart() + section.getToLength() - 1;
        }

        public RegionList getStyleRegions() throws IOException {
            RegionList regions = LinePair.this.ediff != null ? (this.isFrom ? LinePair.this.ediff.getOriginalRegions() : LinePair.this.ediff.getRevisedRegions()) : new RegionList();
            int offset = this.isFrom ? LinePair.this.sectionView.getFromLineOffset(this.lineNumber) : LinePair.this.sectionView.getToLineOffset(this.lineNumber);
            regions = regions.getSubset(offset, offset + this.getLine().length());
            regions.translate(-offset);
            RegionList syntaxHighlightRegions = this.isFrom ? LinePair.this.sectionView.getFromLineSyntaxHighlights(this.lineNumber) : LinePair.this.sectionView.getToLineSyntaxHighlights(this.lineNumber);
            syntaxHighlightRegions.translate(-offset);
            regions.merge(syntaxHighlightRegions);
            return regions;
        }
    }
}

