/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.view.JSONLine;
import com.cenqua.fisheye.vis.Gutter;
import com.cenqua.fisheye.web.tags.AsJavascriptStringTag;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public final class JSONFile {
    private final int blockNumber;
    private final List<Integer> linePositions;
    private final List<JSONLine> lines;
    private final List<Gutter> gutters;

    public JSONFile(int blockNumber, List<Integer> linePositions, List<JSONLine> lines, List<Gutter> gutters) {
        this.blockNumber = blockNumber;
        this.linePositions = linePositions;
        this.lines = lines;
        this.gutters = gutters;
    }

    public List<Gutter> getGutters() {
        return this.gutters;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getTotalLines() {
        return this.linePositions.size();
    }

    public List<Integer> getLinePositions() {
        return this.linePositions;
    }

    public List<JSONLine> getLines() {
        return this.lines;
    }

    public static String getGutterJson(JSONFile jsonFile, int lineNumber) throws IOException {
        if (jsonFile.getGutters().isEmpty()) {
            return "[]";
        }
        StringBuilder json = new StringBuilder("[");
        String sep = "";
        for (Gutter g2 : jsonFile.getGutters()) {
            StringBuilder html = new StringBuilder();
            json.append(sep);
            sep = ",";
            g2.setLineno(lineNumber);
            html.append("<div");
            JSONFile.appendAttribute(html, "class", g2.getCurrentClassList());
            JSONFile.appendAttribute(html, "style", g2.getCurrentStyle());
            html.append(">");
            String gutterHtml = g2.getCurrentHtml();
            if (StringUtils.isNotBlank((String)gutterHtml)) {
                html.append(gutterHtml);
            }
            html.append("</div>");
            json.append(AsJavascriptStringTag.asJavascriptString(html.toString()));
            json.append("]");
        }
        return json.toString();
    }

    private static void appendAttribute(StringBuilder sb, String attrName, String attrValue) {
        if (StringUtils.isNotBlank((String)attrValue)) {
            sb.append(" " + attrName + "=\"" + attrValue + "\"");
        }
    }

    public static String getGutterWidths(JSONFile jsonFile) throws IOException {
        JSONArray array = new JSONArray();
        for (Gutter g2 : jsonFile.getGutters()) {
            array.put((Object)Integer.toString(g2.getWidth()));
        }
        return array.toString();
    }
}

