/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.diff.view.JSONFile;
import com.cenqua.fisheye.diff.view.JSONLine;
import com.cenqua.fisheye.diff.view.LinePair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class JSONDiff {
    private static final int DEFAULT_LINES_PER_PAGE = 100;
    private static final int PAGES_PER_BLOCK = 100;
    private final DiffPrinter diffPrinter;
    private final HunkList hunkList;
    private final JSONFile fromData;
    private final JSONFile toData;
    private final int linesPerPage;

    public JSONDiff(FileDiffExplorer fileDiffExplorer, int fromBlockNumber, int toBlockNumber, Integer linesPerPage) throws IOException {
        this.diffPrinter = fileDiffExplorer.getPrinter();
        this.hunkList = fileDiffExplorer.getHunkList();
        this.linesPerPage = linesPerPage != null && linesPerPage > 0 ? linesPerPage : 100;
        ArrayList<JSONLine> fromLines = new ArrayList<JSONLine>();
        ArrayList<Integer> fromLinePositions = new ArrayList<Integer>();
        ArrayList<JSONLine> toLines = new ArrayList<JSONLine>();
        ArrayList<Integer> toLinePositions = new ArrayList<Integer>();
        Iterator<LinePair> it = this.getLinePairIterator();
        while (it.hasNext()) {
            LinePair.Line toLine;
            boolean isAdd;
            LinePair linePair = it.next();
            boolean isDiff = linePair.getSection().isDiff();
            if (linePair.getShowFrom()) {
                LinePair.Line fromLine;
                boolean isDelete;
                boolean bl = isDelete = isDiff && linePair.getSection().getHunk().isDelete();
                if (isDelete && this.blockNumber(linePair.getToLineNumberEquiv()) == toBlockNumber) {
                    this.markHunkOnOtherSide(toLines, linePair.getToLineNumberEquiv());
                }
                if (fromBlockNumber == this.blockNumber((fromLine = linePair.getFrom()).getLineNumber())) {
                    fromLines.add(new JSONLine(JSONDiff.hunkType(linePair), isDiff && linePair.isStartOfSection(), isDiff && fromLine.isLastLineInSection()));
                }
                fromLinePositions.add(linePair.getToLineNumberEquiv());
            }
            if (!linePair.getShowTo()) continue;
            boolean bl = isAdd = isDiff && linePair.getSection().getHunk().isAdd();
            if (isAdd && this.blockNumber(linePair.getFromLineNumberEquiv()) == fromBlockNumber) {
                this.markHunkOnOtherSide(fromLines, linePair.getFromLineNumberEquiv());
            }
            if (toBlockNumber == this.blockNumber((toLine = linePair.getTo()).getLineNumber())) {
                toLines.add(new JSONLine(JSONDiff.hunkType(linePair), isDiff && linePair.isStartOfSection(), isDiff && toLine.isLastLineInSection()));
            }
            toLinePositions.add(linePair.getFromLineNumberEquiv());
        }
        this.fromData = new JSONFile(fromBlockNumber, fromLinePositions, fromLines, Collections.emptyList());
        this.toData = new JSONFile(toBlockNumber, toLinePositions, toLines, Collections.emptyList());
    }

    private static String hunkType(LinePair linePair) {
        Section section = linePair.getSection();
        if (section.isDiff()) {
            Hunk hunk = section.getHunk();
            if (hunk.isAdd()) {
                return "addition";
            }
            if (hunk.isChange()) {
                return "change";
            }
            return "deletion";
        }
        return null;
    }

    private void markHunkOnOtherSide(List<JSONLine> lines, int lineNumber) {
        if (lineNumber >= 0) {
            int index = this.lineNumberWithinBlock(lineNumber);
            JSONLine line = lines.get(index);
            lines.set(index, new JSONLine(line.getHunkType(), line.isHunkStart(), true));
        }
    }

    private int blockNumber(int lineNumber) {
        return lineNumber / this.getLinesPerBlock();
    }

    private int lineNumberWithinBlock(int lineNumber) {
        return lineNumber % this.getLinesPerBlock();
    }

    public HunkList getHunkList() {
        return this.hunkList;
    }

    public JSONFile getFromData() {
        return this.fromData;
    }

    public JSONFile getToData() {
        return this.toData;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public int getPagesPerBlock() {
        return 100;
    }

    private int getLinesPerBlock() {
        return this.getPagesPerBlock() * this.getLinesPerPage();
    }

    public Iterator<LinePair> getLinePairIterator() {
        return this.diffPrinter.getLinePairIterator();
    }
}

