/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.view.JSONFile;
import com.cenqua.fisheye.diff.view.JSONLine;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.vis.Gutter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class JSONAnnotation {
    private static final int DEFAULT_LINES_PER_PAGE = 100;
    private static final int PAGES_PER_BLOCK = 100;
    private final IndexedLineReader lineReader;
    private final RegionList regions;
    private final String repname;
    private final JSONFile data;
    private final int linesPerPage;

    public JSONAnnotation(IndexedLineReader lineReader, RegionList regions, String repname, int blockNumber, Integer linesPerPage, List<Gutter> gutters) throws IOException {
        this.lineReader = lineReader;
        this.regions = regions;
        this.repname = repname;
        this.linesPerPage = linesPerPage != null && linesPerPage > 0 ? linesPerPage : 100;
        int totalLines = lineReader.getTotalLines();
        List<JSONLine> lines = IntStream.range(0, totalLines).filter(i2 -> blockNumber == this.blockNumber(i2)).boxed().map(i2 -> new JSONLine(null, i2 == 0, i2 == totalLines - 1)).collect(Collectors.toList());
        List<Integer> linePositions = IntStream.range(0, totalLines).boxed().collect(Collectors.toList());
        this.data = new JSONFile(blockNumber, linePositions, lines, gutters);
    }

    private int blockNumber(int lineNumber) {
        return lineNumber / this.getLinesPerBlock();
    }

    public IndexedLineReader getLineReader() {
        return this.lineReader;
    }

    public RegionList getRegions() {
        return this.regions;
    }

    public String getRepname() {
        return this.repname;
    }

    public JSONFile getData() {
        return this.data;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public int getPagesPerBlock() {
        return 100;
    }

    private int getLinesPerBlock() {
        return this.getPagesPerBlock() * this.getLinesPerPage();
    }
}

