/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.diff.view.DiffExplorer;
import com.cenqua.fisheye.diff.view.IndexedLineReaderSectionView;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StringIndexedLineReader;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import java.io.IOException;
import java.util.Collections;

public class FileDiffExplorer
extends DiffExplorer {
    private final IndexedLineReader lineReader1;
    private final IndexedLineReader lineReader2;
    private final RegionList syntaxHiglightsR1;
    private final RegionList syntaxHiglightsR2;

    public FileDiffExplorer(IndexedLineReader lineReader1, IndexedLineReader lineReader2, HunkList hunks, DiffInfo diffInfo, SyntaxDefinition syntaxDefinition, DiffOpts opts) {
        super(hunks, diffInfo, opts);
        this.lineReader1 = lineReader1;
        this.lineReader2 = lineReader2;
        this.syntaxHiglightsR1 = this.createRegionList(syntaxDefinition, this.lineReader1);
        this.syntaxHiglightsR2 = lineReader1.equals(lineReader2) ? this.syntaxHiglightsR1 : this.createRegionList(syntaxDefinition, this.lineReader2);
    }

    public static FileDiffExplorer buildDiffExplorer(RevisionCache contentsSource, FileRevision ri1, FileRevision ri2, DiffOpts diffOpts, String kopt) throws IOException {
        IndexedLineReader lineReader2;
        IndexedLineReader lineReader1;
        LineComparator lc = LineComparator.fromDiffOption(diffOpts);
        if (kopt == null && contentsSource.getRepositoryType() == ScmType.CVS) {
            kopt = KeywordExpansion.KFLAG_K.getName();
        }
        String r1 = "0";
        if (ri1 != null) {
            r1 = ri1.getRevision();
            lineReader1 = contentsSource.getUnicodeTextRevision(ri1, kopt, null);
        } else {
            lineReader1 = new StringIndexedLineReader(Collections.emptyList());
        }
        String r2 = "0";
        if (ri2 != null) {
            r2 = ri2.getRevision();
            lineReader2 = contentsSource.getUnicodeTextRevision(ri2, kopt, null);
        } else {
            lineReader2 = new StringIndexedLineReader(Collections.emptyList());
        }
        HunkList hunks = Diff.diff(new TextFileDiffSequences(lineReader1, lineReader2, lc));
        lineReader1.seekLine(0);
        lineReader2.seekLine(0);
        String name = null;
        if (ri1 != null) {
            name = ri1.getPath().getName();
        } else if (ri2 != null) {
            name = ri2.getPath().getName();
        }
        SyntaxDefinitions defs = AppConfig.getsConfig().getSyntaxDefinitions();
        SyntaxDefinition def = defs == null || name == null ? SyntaxDefinition.PASS_THRU : defs.getSyntaxDefinitionForFile(name);
        DiffInfo diffInfo = new DiffInfo(contentsSource.getRepositoryName(), name, ri1 != null ? ri1.getPath().toString() : null, r1, ri2 != null ? ri2.getPath().toString() : null, r2);
        return new FileDiffExplorer(lineReader1, lineReader2, hunks, diffInfo, def, diffOpts);
    }

    private RegionList createRegionList(SyntaxDefinition syntaxDefinition, IndexedLineReader reader) {
        RegionList regions = new RegionList();
        syntaxDefinition.generateRegions(new InputState(reader.getCharSequence()), regions);
        return regions;
    }

    public IndexedLineReader getLines1() {
        return this.lineReader1;
    }

    public IndexedLineReader getLines2() {
        return this.lineReader2;
    }

    @Override
    protected SectionView makeSectionView(Section s2) {
        return new IndexedLineReaderSectionView(s2, this.lineReader1, this.lineReader2, this.syntaxHiglightsR1, this.syntaxHiglightsR2);
    }
}

