/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.atlassian.fisheye.plugin.descriptor.GutterRendererModuleDescriptor;
import com.atlassian.fisheye.ui.filedecoration.DiffLineDecorator;
import com.atlassian.fisheye.ui.filedecoration.DiffType;
import com.atlassian.fisheye.ui.filedecoration.GutterRenderer;
import com.atlassian.plugin.PluginAccessor;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.EDiff;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.vis.DiffGutter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DiffPrinter {
    private final List<SectionView> sectionViews;
    private final DiffInfo diffInfo;
    private final DiffOpts opts;
    private List<LineData> lineData;
    private List<DiffGutter> gutters;
    private boolean anySkippedSections = false;

    public DiffPrinter(List<SectionView> sectionViews, DiffInfo diffInfo, DiffOpts opts) {
        this.sectionViews = sectionViews;
        this.diffInfo = diffInfo;
        this.opts = opts;
    }

    public boolean isAnySkippedSections() {
        return this.anySkippedSections;
    }

    public void setAnySkippedSections(boolean anySkippedSections) {
        this.anySkippedSections = anySkippedSections;
    }

    public List getSectionViews() {
        return this.sectionViews;
    }

    public SectionView getFirstSectionView() {
        return this.sectionViews.get(0);
    }

    public SectionView getLastSectionView() {
        return this.sectionViews.get(this.sectionViews.size() - 1);
    }

    public boolean isSideBySide() {
        return this.opts.sideBySide();
    }

    public boolean isUnified() {
        return !this.isSideBySide();
    }

    public void setSideBySide(boolean sbs) {
        this.opts.setSideBySide(sbs);
        this.resetLinePairs();
    }

    private void resetLinePairs() {
        this.lineData = null;
    }

    private void precalcLinePairs() {
        if (this.lineData != null) {
            return;
        }
        this.lineData = new ArrayList<LineData>();
        for (SectionView sv : this.sectionViews) {
            int lineOff;
            Section section = sv.getSection();
            boolean startOfSection = true;
            if (section.isCommonSubsequence() || this.isSideBySide()) {
                int maxLines = Math.max(section.getFromLength(), section.getToLength());
                for (lineOff = 0; lineOff < maxLines; ++lineOff) {
                    Integer fromLine = null;
                    Integer toLine = null;
                    if (lineOff < section.getFromLength()) {
                        fromLine = section.getFromStart() + lineOff;
                    }
                    if (lineOff < section.getToLength()) {
                        toLine = section.getToStart() + lineOff;
                    }
                    LineData lp = new LineData(sv, startOfSection, startOfSection, fromLine, toLine);
                    this.lineData.add(lp);
                    startOfSection = false;
                }
                continue;
            }
            for (int lineOff2 = 0; lineOff2 < section.getFromLength(); ++lineOff2) {
                Integer fromLine = section.getFromStart() + lineOff2;
                LineData lp = new LineData(sv, startOfSection, startOfSection, fromLine, null);
                this.lineData.add(lp);
                startOfSection = false;
            }
            boolean startOfSubSection = true;
            for (lineOff = 0; lineOff < section.getToLength(); ++lineOff) {
                Integer toLine = section.getToStart() + lineOff;
                LineData lp = new LineData(sv, startOfSection, startOfSubSection, null, toLine);
                this.lineData.add(lp);
                startOfSection = false;
                startOfSubSection = false;
            }
        }
    }

    public Iterator<LinePair> getLinePairIterator() {
        this.precalcLinePairs();
        return new Iterator<LinePair>(){
            private int currentPairIndex = -1;
            public EDiff currentEdiff;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.currentPairIndex + 1 < DiffPrinter.this.lineData.size();
            }

            @Override
            public LinePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.currentPairIndex;
                LineData ld = (LineData)DiffPrinter.this.lineData.get(this.currentPairIndex);
                LinePair lp = new LinePair(DiffPrinter.this, ld.sectionView, ld.startOfSection, ld.startOfSubSection, ld.fromLine, ld.toLine);
                if (lp.isStartOfSection()) {
                    this.currentEdiff = DiffPrinter.this.setupEdiff(lp.getSectionView());
                }
                lp.setEdiff(this.currentEdiff);
                return lp;
            }
        };
    }

    public int getNumberOfNavHandles() throws IOException {
        this.precalcLinePairs();
        int count = 0;
        boolean navHandleForSection = false;
        if (this.sectionViews.size() > 0) {
            SectionView firstSectionView = this.getFirstSectionView();
            SectionView lastSectionView = this.getLastSectionView();
            for (LineData ld : this.lineData) {
                if (ld.startOfSection) {
                    navHandleForSection = false;
                }
                if (!(navHandleForSection || ld.sectionView != firstSectionView && ld.sectionView != lastSectionView && ld.sectionView.getSection().isCommonSubsequence())) {
                    ++count;
                }
                navHandleForSection = true;
            }
        }
        return count;
    }

    public static List<DiffGutter> getPluginGutters(CrucibleRevision from, CrucibleRevision to, DiffOpts opts) {
        if (from == null || to == null) {
            return Collections.emptyList();
        }
        return DiffPrinter.getPluginGutters(opts, from.getSourceName(), from.getPath(), from.getRevision(), to.getPath(), to.getRevision());
    }

    private static List<DiffGutter> getPluginGutters(DiffOpts opts, String repname, String fromPath, String fromRev, String toPath, String toREv) {
        ArrayList<DiffGutter> gutters = new ArrayList<DiffGutter>();
        try {
            PluginAccessor pluginAccessor = SpringContext.getComponentByClass(PluginAccessor.class);
            for (GutterRendererModuleDescriptor d2 : pluginAccessor.getEnabledModuleDescriptorsByClass(GutterRendererModuleDescriptor.class)) {
                List decorators = ((GutterRenderer)d2.getModule()).getAnnotationDecorators(opts.sideBySide() ? DiffType.SIDEBYSIDE : DiffType.UNIFIED, repname, fromPath, fromRev, toPath, toREv);
                for (DiffLineDecorator decorator : decorators) {
                    gutters.add(new DiffGutter(decorator));
                }
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"problem getting gutter renderers", (Throwable)e2);
        }
        return gutters;
    }

    public List<DiffGutter> getPluginGutters() {
        if (this.gutters == null) {
            this.gutters = DiffPrinter.getPluginGutters(this.opts, this.diffInfo.getRepName(), this.diffInfo.getFromPath(), this.diffInfo.getFromRev(), this.diffInfo.getToPath(), this.diffInfo.getToRev());
        }
        return this.gutters;
    }

    private EDiff setupEdiff(SectionView sv) {
        Section section = sv.getSection();
        if (section.isDiff() && section.getHunk().isChange()) {
            int sizeThres = 30;
            int closeThres = 10;
            int blockThresh = 10000;
            Hunk h2 = section.getHunk();
            int size = h2.getFromCount() + h2.getToCount();
            int close = Math.abs(h2.getFromCount() - h2.getToCount());
            if (size <= 30 && close <= 10) {
                CharSequence cs2;
                long t0 = System.currentTimeMillis();
                CharSequence cs1 = sv.getFromLines();
                EDiff ediff = new EDiff(cs1, cs2 = sv.getToLines(), this.opts);
                if (ediff.getTotalBlockLength() < 10000) {
                    ediff.doDiff();
                    long t1 = System.currentTimeMillis();
                    Logs.APP_LOG.debug((Object)("ediff computed in " + (t1 - t0) + "ms"));
                    return ediff;
                }
            }
        }
        return null;
    }

    private static class LineData {
        SectionView sectionView;
        boolean startOfSection;
        boolean startOfSubSection;
        Integer fromLine;
        Integer toLine;

        public LineData(SectionView sectionView, boolean startOfSection, boolean startOfSubSection, Integer fromLine, Integer toLine) {
            this.sectionView = sectionView;
            this.startOfSection = startOfSection;
            this.startOfSubSection = startOfSubSection;
            this.fromLine = fromLine;
            this.toLine = toLine;
        }
    }
}

