/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.SectionView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DiffExplorer {
    public static final int DEFAULT_CONTEXT_LINES = 3;
    protected final HunkList hunks;
    private int contextLines = 3;
    private final DiffInfo diffInfo;
    private List<Section> sections;
    private DiffPrinter printer;
    private DiffOpts opts;

    public DiffExplorer(HunkList hunks, DiffInfo diffInfo, DiffOpts opts) {
        this.hunks = hunks;
        this.diffInfo = diffInfo;
        this.opts = opts;
    }

    public String getR1() {
        return this.diffInfo.getFromRev();
    }

    public String getR2() {
        return this.diffInfo.getToRev();
    }

    public HunkList getHunkList() {
        return this.hunks;
    }

    public void setContextLines(int contextLines) {
        this.contextLines = contextLines;
        this.sections = null;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    public boolean isAnySkippedSections() throws IOException {
        List<Section> l2 = this.getSections();
        for (Section section : l2) {
            if (!section.isSkippedPrevious()) continue;
            return true;
        }
        return false;
    }

    public List<Section> getSections() throws IOException {
        if (this.sections == null) {
            this.sections = this.hunks.getSections(this.contextLines);
        }
        return this.sections;
    }

    public DiffPrinter getPrinter() throws IOException {
        if (this.printer == null) {
            this.printer = this.makePrinter(this.getSections());
            this.printer.setAnySkippedSections(this.isAnySkippedSections());
        }
        return this.printer;
    }

    private DiffPrinter makePrinter(List<Section> sections) {
        ArrayList<SectionView> views = new ArrayList<SectionView>(sections.size());
        for (Section s2 : sections) {
            views.add(this.makeSectionView(s2));
        }
        return new DiffPrinter(views, this.diffInfo, this.opts);
    }

    protected abstract SectionView makeSectionView(Section var1);

    public boolean isIdentical() throws IOException {
        Iterator<Hunk> i2 = this.hunks.getIterator();
        while (i2.hasNext()) {
            Hunk hunk = i2.next();
            if (hunk.isIgnored()) continue;
            return false;
        }
        return true;
    }
}

