/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.RemappingDiffSequences;
import com.cenqua.fisheye.io.IndexedLineReader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;

public class TextFileDiffSequences
extends RemappingDiffSequences {
    private final IndexedLineReader mOrig;
    private final IndexedLineReader mRevised;
    private final LineComparator mCmp;
    private final StringBuffer mOrigLine = new StringBuffer();
    private final StringBuffer mRevisedLine = new StringBuffer();

    public TextFileDiffSequences(IndexedLineReader aOrig, IndexedLineReader aRevised, LineComparator cmp) throws IOException {
        super(cmp.supportsIgnore());
        this.mOrig = aOrig;
        this.mRevised = aRevised;
        this.mCmp = cmp;
        IntArrayList origHashes = new IntArrayList();
        IntArrayList revisedHashes = new IntArrayList();
        this.scanFile(this.mOrigLine, this.mOrig, (IntList)origHashes);
        this.scanFile(this.mRevisedLine, this.mRevised, (IntList)revisedHashes);
        this.setup((IntList)origHashes, (IntList)revisedHashes);
    }

    private void scanFile(StringBuffer tmpBuf, IndexedLineReader reader, IntList hashes) throws IOException {
        tmpBuf.setLength(0);
        while (reader.readline(tmpBuf) != -1) {
            int hc = this.mCmp.hashcode(tmpBuf);
            hashes.add(hc);
            tmpBuf.setLength(0);
        }
    }

    @Override
    protected boolean equalImpl(int aOriginalIndex, int aRevisionIndex) {
        try {
            this.loadOrigLine(aOriginalIndex);
            this.loadRevisedLine(aRevisionIndex);
            return this.mCmp.equals(this.mOrigLine, this.mRevisedLine);
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    protected boolean ignoreOriginalLine(int i2) {
        try {
            this.loadOrigLine(i2);
            return this.mCmp.ignore(this.mOrigLine);
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    protected boolean ignoreRevisedLine(int i2) {
        try {
            this.loadRevisedLine(i2);
            return this.mCmp.ignore(this.mRevisedLine);
        }
        catch (IOException e2) {
            return false;
        }
    }

    private void loadRevisedLine(int aRevisionIndex) throws IOException {
        this.mRevisedLine.setLength(0);
        this.mRevised.seekLine(aRevisionIndex);
        this.mRevised.readline(this.mRevisedLine);
    }

    private void loadOrigLine(int aOriginalIndex) throws IOException {
        this.mOrigLine.setLength(0);
        this.mOrig.seekLine(aOriginalIndex);
        this.mOrig.readline(this.mOrigLine);
    }
}

