/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.io.IndexedLineReader;
import java.io.IOException;

public class Section {
    private final boolean commonSubsequence;
    private final Hunk hunk;
    private boolean skippedPrevious;

    public Section(boolean commonSubsequence, Hunk hunk) {
        this(commonSubsequence, hunk, false);
    }

    public Section(boolean commonSubsequence, Hunk hunk, boolean skippedPrevious) {
        this.commonSubsequence = commonSubsequence;
        this.hunk = hunk;
        this.skippedPrevious = skippedPrevious;
    }

    public boolean isCommonSubsequence() {
        return this.commonSubsequence;
    }

    public boolean isDiff() {
        return !this.commonSubsequence;
    }

    public boolean isSkippedPrevious() {
        return this.skippedPrevious;
    }

    void setSkippedPrevious(boolean skippedPrevious) {
        this.skippedPrevious = skippedPrevious;
    }

    public Hunk getHunk() {
        return this.hunk;
    }

    public int getFromStart() {
        return this.hunk.getFrom();
    }

    public int getToStart() {
        return this.hunk.getTo();
    }

    public int getFromLength() {
        return this.hunk.getFromCount();
    }

    public int getToLength() {
        return this.hunk.getToCount();
    }

    public boolean toHasTrailingEOL(IndexedLineReader lr) throws IOException {
        return Section.hasTrailingEOL(lr, this.getToStart(), this.getToLength());
    }

    public boolean fromHasTrailingEOL(IndexedLineReader lr) throws IOException {
        return Section.hasTrailingEOL(lr, this.getFromStart(), this.getFromLength());
    }

    private static boolean hasTrailingEOL(IndexedLineReader lines, int start, int length) throws IOException {
        if (start + length < lines.getTotalLines()) {
            return true;
        }
        return lines.isEolTerminated();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Section section = (Section)o2;
        if (this.commonSubsequence != section.commonSubsequence) {
            return false;
        }
        if (this.skippedPrevious != section.skippedPrevious) {
            return false;
        }
        return !(this.hunk != null ? !this.hunk.equals(section.hunk) : section.hunk != null);
    }

    public int hashCode() {
        int result = this.commonSubsequence ? 1 : 0;
        result = 31 * result + (this.hunk != null ? this.hunk.hashCode() : 0);
        result = 31 * result + (this.skippedPrevious ? 1 : 0);
        return result;
    }

    public String toString() {
        return "section<cs=" + this.isCommonSubsequence() + ":" + this.getFromStart() + ":" + this.getFromLength() + " - " + this.getToStart() + ":" + this.getToLength() + ">";
    }
}

