/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.RemappingDiffSequences;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.util.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;

public class RegionListDiffSequences
extends RemappingDiffSequences {
    private final List<Region> mOrig;
    private final List<Region> mRevised;
    private final CharSequence mOrigSequence;
    private final CharSequence mRevisedSequence;
    private final LineComparator mLineComparator;

    public RegionListDiffSequences(List<Region> orig, CharSequence origSequence, List<Region> revised, CharSequence revisedSequence, DiffOpts opts) {
        super(false);
        this.mOrig = orig;
        this.mRevised = revised;
        this.mOrigSequence = origSequence;
        this.mRevisedSequence = revisedSequence;
        this.mLineComparator = LineComparator.fromDiffOption(opts);
        IntArrayList origHashes = new IntArrayList(this.mOrig.size());
        IntArrayList revisedHashes = new IntArrayList(this.mRevised.size());
        RegionListDiffSequences.hashRegions(orig, this.mOrigSequence, (IntList)origHashes);
        RegionListDiffSequences.hashRegions(revised, this.mRevisedSequence, (IntList)revisedHashes);
        this.setup((IntList)origHashes, (IntList)revisedHashes);
    }

    private static void hashRegions(List<Region> regions, CharSequence input, IntList hashes) {
        for (Region region : regions) {
            CharSequence s2 = RegionListDiffSequences.getCharSequence(input, region);
            hashes.add(StringUtil.stringHashCode(s2));
        }
    }

    @Override
    public boolean equal(int aOriginalIndex, int aRevisionIndex) {
        return this.equalImpl(aOriginalIndex, aRevisionIndex);
    }

    @Override
    protected boolean equalImpl(int aOriginalIndex, int aRevisionIndex) {
        Region a2 = this.mOrig.get(aOriginalIndex);
        Region b2 = this.mRevised.get(aRevisionIndex);
        StringBuffer sa = new StringBuffer(RegionListDiffSequences.getCharSequence(this.mOrigSequence, a2));
        StringBuffer sb = new StringBuffer(RegionListDiffSequences.getCharSequence(this.mRevisedSequence, b2));
        return this.mLineComparator.equals(sa, sb);
    }

    private static CharSequence getCharSequence(CharSequence s2, Region a2) {
        return s2.subSequence(a2.getStart(), a2.getEnd());
    }

    @Override
    protected boolean ignoreOriginalLine(int i2) {
        return false;
    }

    @Override
    protected boolean ignoreRevisedLine(int i2) {
        return false;
    }
}

