/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.PathNode;

public class MyersOND {
    private MyersOND() {
    }

    public static HunkList diff(DiffSequences sequences) {
        int N2 = sequences.getOriginalSize();
        int M2 = sequences.getRevisedSize();
        if (N2 == 0 && M2 == 0) {
            return new HunkList(sequences.getOriginalSize(), sequences.getRevisedSize());
        }
        PathNode path = MyersOND.buildPath(sequences);
        return MyersOND.buildRevision(path, sequences);
    }

    private static PathNode buildPath(DiffSequences sequences) {
        int N2 = sequences.getOriginalSize();
        int M2 = sequences.getRevisedSize();
        int MAX = N2 + M2 + 1;
        int size = 1 + 2 * MAX;
        int middle = (size + 1) / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = PathNode.Snake(0, -1, null);
        for (int d2 = 0; d2 < MAX; ++d2) {
            for (int k2 = -d2; k2 <= d2; k2 += 2) {
                int j2;
                PathNode prev;
                int i2;
                int kmiddle = middle + k2;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                if (k2 == -d2 || k2 != d2 && diagonal[kminus].i < diagonal[kplus].i) {
                    i2 = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i2 = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = PathNode.DiffNode(i2, j2, prev);
                for (j2 = i2 - k2; i2 < N2 && j2 < M2 && sequences.equal(i2, j2); ++i2, ++j2) {
                }
                if (i2 > node.i) {
                    node = PathNode.Snake(i2, j2, node);
                }
                diagonal[kmiddle] = node;
                if (i2 < N2 || j2 < M2) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d2 - 1] = null;
        }
        throw new RuntimeException("could not find a diff path");
    }

    private static HunkList buildRevision(PathNode path, DiffSequences sequences) {
        HunkList revision = new HunkList(sequences.getOriginalSize(), sequences.getRevisedSize());
        if (path.snake) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.snake) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i2 = path.i;
            int j2 = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Hunk hunk = new Hunk(ianchor, janchor, i2 - ianchor, j2 - janchor);
            hunk.setIgnored(sequences.ignore(hunk));
            revision.insertDelta(hunk);
            if (!path.snake) continue;
            path = path.prev;
        }
        return revision;
    }
}

