/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.DiffSequences;
import java.util.Arrays;
import java.util.List;

public class ListDiffSequences<T>
extends DiffSequences {
    private final List<T> mOriginal;
    private final List<T> mRevised;

    public ListDiffSequences(List<T> aOriginal, List<T> aRevised) {
        this.mOriginal = aOriginal;
        this.mRevised = aRevised;
    }

    public ListDiffSequences(T[] aOriginal, T[] aRevised) {
        this(Arrays.asList(aOriginal), Arrays.asList(aRevised));
    }

    @Override
    public int getOriginalSize() {
        return this.mOriginal.size();
    }

    @Override
    public int getRevisedSize() {
        return this.mRevised.size();
    }

    @Override
    public boolean equal(int aOriginalIndex, int aRevisionIndex) {
        T a2 = this.mOriginal.get(aOriginalIndex);
        T b2 = this.mRevised.get(aRevisionIndex);
        if (a2 == null) {
            return b2 == null;
        }
        return a2.equals(b2);
    }
}

