/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.util.StringUtil;

public abstract class LineComparator {
    public static final Identical IDENTICAL = new Identical();
    public static final IgnoreSpaceChange IGNORE_SPACE_CHANGE = new IgnoreSpaceChange();
    public static final IgnoreAllSpace IGNORE_ALL_SPACE = new IgnoreAllSpace();
    private final boolean mSupportsIgnore;

    public LineComparator(boolean supportsIgnore) {
        this.mSupportsIgnore = supportsIgnore;
    }

    public static LineComparator fromDiffOption(DiffOpts opts) {
        if (opts == null) {
            return IDENTICAL;
        }
        if (opts.isIgnoreBlankLines()) {
            return new IgnoreBlankLines(opts);
        }
        if (opts.isIgnoreAllWhitespace()) {
            return IGNORE_ALL_SPACE;
        }
        if (opts.isIgnoreSignificantWhitespace()) {
            return IGNORE_SPACE_CHANGE;
        }
        return IDENTICAL;
    }

    public abstract boolean equals(StringBuffer var1, StringBuffer var2);

    public abstract int hashcode(StringBuffer var1);

    public boolean supportsIgnore() {
        return this.mSupportsIgnore;
    }

    public boolean ignore(StringBuffer line) {
        return false;
    }

    private static void removeSpaceChanges(StringBuffer buf) {
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.setLength(buf.length() - 1);
        }
        int i2 = 0;
        boolean inWhitespaceSpan = false;
        while (i2 < buf.length()) {
            char c2 = buf.charAt(i2);
            if (Character.isWhitespace(c2)) {
                if (inWhitespaceSpan) {
                    buf.deleteCharAt(i2);
                    continue;
                }
                buf.setCharAt(i2, ' ');
                ++i2;
                inWhitespaceSpan = true;
                continue;
            }
            ++i2;
            inWhitespaceSpan = false;
        }
    }

    private static void removeSpaces(StringBuffer buf) {
        int i2 = 0;
        while (i2 < buf.length()) {
            char c2 = buf.charAt(i2);
            if (Character.isWhitespace(c2)) {
                buf.deleteCharAt(i2);
                continue;
            }
            ++i2;
        }
    }

    private static boolean stringsIdentical(StringBuffer a2, StringBuffer b2) {
        if (a2.length() != b2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length(); ++i2) {
            char cb;
            char ca = a2.charAt(i2);
            if (ca == (cb = b2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public String toDiffOptsString() {
        return null;
    }

    private static void stripEOL(StringBuffer s2) {
        if (s2.length() > 0 && s2.charAt(s2.length() - 1) == '\n') {
            s2.setLength(s2.length() - 1);
        }
        if (s2.length() > 0 && s2.charAt(s2.length() - 1) == '\r') {
            s2.setLength(s2.length() - 1);
        }
    }

    public static class IgnoreBlankLines
    extends LineComparator {
        private final boolean mIgnoreChange;
        private final boolean mIgnoreAllSpace;

        public IgnoreBlankLines(DiffOpts opts) {
            super(true);
            this.mIgnoreChange = opts.isIgnoreSignificantWhitespace();
            this.mIgnoreAllSpace = opts.isIgnoreAllWhitespace();
        }

        @Override
        public boolean equals(StringBuffer a2, StringBuffer b2) {
            this.cleanup(a2);
            this.cleanup(b2);
            return LineComparator.stringsIdentical(a2, b2);
        }

        @Override
        public int hashcode(StringBuffer line) {
            this.cleanup(line);
            return StringUtil.stringHashCode(line);
        }

        @Override
        public boolean ignore(StringBuffer line) {
            this.cleanup(line);
            return line.length() == 0;
        }

        private void cleanup(StringBuffer line) {
            LineComparator.stripEOL(line);
            if (this.mIgnoreAllSpace) {
                LineComparator.removeSpaces(line);
            }
            if (this.mIgnoreChange) {
                LineComparator.removeSpaceChanges(line);
            }
        }

        @Override
        public String toDiffOptsString() {
            return "B" + (this.mIgnoreAllSpace ? "w" : "") + (this.mIgnoreChange ? "b" : "");
        }
    }

    public static class IgnoreAllSpace
    extends Identical {
        @Override
        public boolean equals(StringBuffer a2, StringBuffer b2) {
            LineComparator.removeSpaces(a2);
            LineComparator.removeSpaces(b2);
            return super.equals(a2, b2);
        }

        @Override
        public int hashcode(StringBuffer line) {
            LineComparator.removeSpaces(line);
            return super.hashcode(line);
        }

        @Override
        public String toDiffOptsString() {
            return "w";
        }
    }

    public static class IgnoreSpaceChange
    extends Identical {
        @Override
        public boolean equals(StringBuffer a2, StringBuffer b2) {
            LineComparator.removeSpaceChanges(a2);
            LineComparator.removeSpaceChanges(b2);
            return super.equals(a2, b2);
        }

        @Override
        public int hashcode(StringBuffer line) {
            LineComparator.removeSpaceChanges(line);
            return super.hashcode(line);
        }

        @Override
        public String toDiffOptsString() {
            return "b";
        }
    }

    public static class Identical
    extends LineComparator {
        public Identical() {
            super(false);
        }

        @Override
        public boolean equals(StringBuffer a2, StringBuffer b2) {
            return LineComparator.stringsIdentical(a2, b2);
        }

        @Override
        public int hashcode(StringBuffer line) {
            return StringUtil.stringHashCode(line);
        }
    }
}

