/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.Section;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HunkList {
    private final List<Hunk> hunks = new ArrayList<Hunk>();
    private final int fromSize;
    private final int toSize;
    private final boolean zeroBased;

    public HunkList(int fromSize, int toSize) {
        this(fromSize, toSize, true);
    }

    public HunkList(int fromSize, int toSize, boolean zeroBased) {
        this.fromSize = fromSize;
        this.toSize = toSize;
        this.zeroBased = zeroBased;
    }

    public String toString() {
        return this.hunks.toString();
    }

    public int getFromSize() {
        return this.fromSize;
    }

    public int getToSize() {
        return this.toSize;
    }

    public Iterator<Hunk> getIterator() {
        return this.hunks.iterator();
    }

    public void insertDelta(Hunk hunk) {
        this.hunks.add(0, hunk);
    }

    public void setHunks(List<Hunk> hunks) {
        this.hunks.clear();
        this.hunks.addAll(hunks);
    }

    public int size() {
        return this.hunks.size();
    }

    public Hunk getHunk(int i2) {
        return this.hunks.get(i2);
    }

    public List<Section> getSections() throws IOException {
        return this.getSections(-1);
    }

    public List<Section> getSections(final int linesOfContext) throws IOException {
        final ArrayList<Section> sections = new ArrayList<Section>(this.hunks.size() * 2 + 2);
        Visitor v2 = new Visitor(){

            @Override
            public void change(Hunk hunk) {
                this.addDiff(hunk);
            }

            @Override
            public void add(Hunk hunk) {
                this.addDiff(hunk);
            }

            @Override
            public void delete(Hunk hunk) {
                this.addDiff(hunk);
            }

            @Override
            public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
                Section sect = new Section(true, new Hunk(fromStart, toStart, lenx, leny));
                sect.setSkippedPrevious(skipPrevious);
                sections.add(sect);
            }

            private void addDiff(Hunk hunk) {
                Section sect = new Section(false, hunk);
                if (linesOfContext == 0) {
                    sect.setSkippedPrevious(true);
                }
                sections.add(sect);
            }
        };
        this.visit(v2, linesOfContext);
        return sections;
    }

    public void visit(Visitor visitor) throws IOException {
        this.visit(visitor, -1);
    }

    public void visit(Visitor visitor, int linesOfContext) throws IOException {
        VisitorAlg alg = new VisitorAlg(visitor, linesOfContext);
        alg.visit();
    }

    static /* synthetic */ boolean access$000(HunkList x0) {
        return x0.zeroBased;
    }

    class VisitorAlg {
        final Visitor visitor;
        final int linesOfContext;
        boolean isFirst = true;
        int lastx = HunkList.access$000(HunkList.this) ? 0 : 1;
        int lasty = HunkList.access$000(HunkList.this) ? 0 : 1;

        public VisitorAlg(Visitor visitor, int linesOfContext) {
            this.visitor = visitor;
            this.linesOfContext = linesOfContext;
        }

        public void visit() throws IOException {
            int leny;
            int lenx;
            int len;
            boolean ignoredAllHunksSoFar = true;
            for (int i2 = 0; i2 < HunkList.this.hunks.size(); ++i2) {
                Hunk hunk = (Hunk)HunkList.this.hunks.get(i2);
                if (!hunk.isIgnored() || ignoredAllHunksSoFar && i2 == HunkList.this.hunks.size() - 1 || this.linesOfContext != 0 && (this.linesOfContext <= 0 || this.closeToNeighbours(i2))) {
                    ignoredAllHunksSoFar = false;
                    if (this.lastx < hunk.getFrom() || this.lasty < hunk.getTo()) {
                        int lenx2 = hunk.getFrom() - this.lastx;
                        int leny2 = hunk.getTo() - this.lasty;
                        this.visitCommon(false, lenx2, leny2);
                    }
                    if (hunk.isChange()) {
                        this.visitor.change(hunk);
                    } else if (hunk.isAdd()) {
                        this.visitor.add(hunk);
                    } else if (hunk.isDelete()) {
                        this.visitor.delete(hunk);
                    }
                    this.lastx = hunk.getFrom() + hunk.getFromCount();
                    this.lasty = hunk.getTo() + hunk.getToCount();
                }
                this.isFirst = false;
            }
            if (this.lastx < HunkList.this.getFromSize() && (len = Math.min(lenx = HunkList.this.getFromSize() - this.lastx, leny = HunkList.this.getToSize() - this.lasty)) != 0) {
                this.visitCommon(true, len, len);
            }
        }

        private boolean closeToNeighbours(int i2) {
            Hunk next;
            Hunk prev;
            Hunk hunk = (Hunk)HunkList.this.hunks.get(i2);
            if (i2 > 0 && this.close(prev = (Hunk)HunkList.this.hunks.get(i2 - 1), hunk)) {
                return true;
            }
            return i2 + 1 < HunkList.this.hunks.size() && this.close(hunk, next = (Hunk)HunkList.this.hunks.get(i2 + 1));
        }

        private boolean close(Hunk a2, Hunk b2) {
            int maxLen;
            int len = b2.getFrom() - a2.getFrom() + a2.getFromCount();
            return len <= (maxLen = this.linesOfContext * 2 + 1);
        }

        private void visitCommon(boolean isLast, int lenx, int leny) throws IOException {
            int maxLen;
            if (this.linesOfContext == 0) {
                return;
            }
            if (this.linesOfContext < 0) {
                this.visitor.common(this.lastx, this.lasty, lenx, leny, false);
                return;
            }
            int n2 = maxLen = this.isFirst || isLast ? this.linesOfContext : this.linesOfContext * 2 + 1;
            if (lenx > maxLen) {
                int xCtx = Math.min(lenx, this.linesOfContext);
                int yCtx = Math.min(leny, this.linesOfContext);
                if (!this.isFirst) {
                    this.visitor.common(this.lastx, this.lasty, xCtx, yCtx, false);
                }
                if (!isLast) {
                    boolean skipPrevious = !this.isFirst;
                    this.visitor.common(this.lastx + lenx - xCtx, this.lasty + leny - yCtx, xCtx, yCtx, skipPrevious);
                }
            } else {
                this.visitor.common(this.lastx, this.lasty, lenx, leny, false);
            }
        }
    }

    public static interface Visitor {
        public void common(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

        public void change(Hunk var1) throws IOException;

        public void add(Hunk var1) throws IOException;

        public void delete(Hunk var1) throws IOException;
    }
}

