/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.util.NaturalComparator;
import java.util.Comparator;

public class Hunk
implements Comparable<Hunk> {
    private final int from;
    private final int fromCount;
    private final int to;
    private final int toCount;
    private boolean ignored;
    public static final Comparator<Hunk> comp = new NaturalComparator<Hunk>();

    public Hunk(int from, int to, int fromCount, int toCount) {
        this.from = from;
        this.fromCount = fromCount;
        this.to = to;
        this.toCount = toCount;
    }

    public static Hunk createUnifiedAddHunk(int fromLine, int toLine, int count) {
        return new Hunk(fromLine - 1, toLine, 0, count);
    }

    public static Hunk createUnifiedDeleteHunk(int fromLine, int toLine, int count) {
        return new Hunk(fromLine, toLine - 1, count, 0);
    }

    public int getFrom() {
        return this.from;
    }

    public int getFromCount() {
        return this.fromCount;
    }

    public int getTo() {
        return this.to;
    }

    public int getToCount() {
        return this.toCount;
    }

    public boolean isDelete() {
        return this.toCount == 0;
    }

    public boolean isAdd() {
        return this.fromCount == 0;
    }

    public boolean isChange() {
        return !this.isAdd() && !this.isDelete();
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Hunk hunk = (Hunk)o2;
        if (this.ignored != hunk.ignored) {
            return false;
        }
        if (this.from != hunk.from) {
            return false;
        }
        if (this.fromCount != hunk.fromCount) {
            return false;
        }
        if (this.to != hunk.to) {
            return false;
        }
        return this.toCount == hunk.toCount;
    }

    public int hashCode() {
        int result = this.from;
        result = 29 * result + this.fromCount;
        result = 29 * result + this.to;
        result = 29 * result + this.toCount;
        result = 29 * result + (this.ignored ? 1 : 0);
        return result;
    }

    public String toString() {
        String mod;
        String string = this.isDelete() ? "d" : (mod = this.isAdd() ? "a" : "c");
        if (this.ignored) {
            mod = mod + "-ignored";
        }
        return mod + "<" + this.from + ":" + this.fromCount + " , " + this.to + ":" + this.toCount + ">";
    }

    public Hunk getReverse() {
        return new Hunk(this.to, this.from, this.toCount, this.fromCount);
    }

    @Override
    public int compareTo(Hunk hunk) {
        return this.from - hunk.getFrom();
    }
}

