/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.RegionListDiffSequences;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EDiff {
    private RegionListDiffSequences seq;
    private HunkList mHunks;
    private final List<Region> mA1;
    private final List<Region> mB1;

    public EDiff(CharSequence a2, CharSequence b2, DiffOpts opts) {
        this.mA1 = this.makeBlock(a2);
        this.mB1 = this.makeBlock(b2);
        this.seq = new RegionListDiffSequences(this.mA1, a2, this.mB1, b2, opts);
    }

    public void doDiff() {
        this.mHunks = Diff.diff(this.seq);
    }

    public int getTotalBlockLength() {
        return this.mA1.size() + this.mB1.size();
    }

    private List<Region> makeBlock(CharSequence a2) {
        ArrayList<Region> block = new ArrayList<Region>();
        this.splitInput(block, a2);
        return block;
    }

    private void splitInput(List<Region> positions, CharSequence input) {
        int i2 = 0;
        while (i2 < input.length()) {
            int len;
            char c2 = input.charAt(i2);
            if (EDiff.isWordChar(c2)) {
                len = this.findWordLength(input, i2);
                this.createRegion(positions, i2, len);
                i2 += len;
                continue;
            }
            if (Character.isWhitespace(c2)) {
                len = this.findWhitespaceLength(c2, input, i2);
                this.createRegion(positions, i2, len);
                i2 += len;
                continue;
            }
            this.createRegion(positions, i2, 1);
            ++i2;
        }
    }

    private void createRegion(List<Region> positions, int start, int length) {
        Region pos = new Region(start, start + length);
        positions.add(pos);
    }

    private int findWordLength(CharSequence input, int start) {
        int len = 1;
        while (start + len < input.length() && EDiff.isWordChar(input.charAt(start + len))) {
            ++len;
        }
        return len;
    }

    private int findWhitespaceLength(char c2, CharSequence input, int start) {
        int len = 1;
        while (start + len < input.length() && c2 == input.charAt(start + len)) {
            ++len;
        }
        return len;
    }

    public RegionList getOriginalRegions() throws IOException {
        HunkVisitor hv = new HunkVisitor(this.mA1){

            @Override
            public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
            }

            @Override
            public void change(Hunk hunk) {
                this.process(hunk.getFrom(), hunk.getFromCount());
            }

            @Override
            public void add(Hunk hunk) {
            }

            @Override
            public void delete(Hunk hunk) {
                this.process(hunk.getFrom(), hunk.getFromCount());
            }
        };
        this.mHunks.visit(hv);
        return hv.computeRegionList();
    }

    public RegionList getRevisedRegions() throws IOException {
        HunkVisitor hv = new HunkVisitor(this.mB1){

            @Override
            public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
            }

            @Override
            public void change(Hunk hunk) {
                this.process(hunk.getTo(), hunk.getToCount());
            }

            @Override
            public void add(Hunk hunk) {
                this.process(hunk.getTo(), hunk.getToCount());
            }

            @Override
            public void delete(Hunk hunk) {
            }
        };
        this.mHunks.visit(hv);
        return hv.computeRegionList();
    }

    private static boolean isWordChar(char c2) {
        return Character.isLetterOrDigit(c2);
    }

    private static abstract class HunkVisitor
    implements HunkList.Visitor {
        private final List<Region> tokens;
        private List<Region> regions = new ArrayList<Region>();
        private final Map<String, String> mChangeProps = new HashMap<String, String>();

        public HunkVisitor(List<Region> tokens) {
            this.tokens = tokens;
            this.mChangeProps.put("ediff", "changed");
        }

        protected void process(int start, int len) {
            for (int i2 = start; i2 < start + len; ++i2) {
                Region prev = this.regions.isEmpty() ? null : this.regions.get(this.regions.size() - 1);
                Region token = this.tokens.get(i2);
                if (prev != null && prev.getEnd() == token.getStart()) {
                    this.regions.set(this.regions.size() - 1, prev.resize(prev.getStart(), token.getEnd()));
                    continue;
                }
                this.regions.add(new Region(token.getStart(), token.getEnd(), this.mChangeProps));
            }
        }

        protected RegionList computeRegionList() {
            RegionList regionList = new RegionList();
            for (Region r2 : this.regions) {
                regionList.add(r2);
            }
            return regionList;
        }
    }
}

