/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

public class DiffOpts {
    private WhitespaceOpts whitespaceOpts;
    private boolean ignoreBlankLines;
    private boolean softWrap;
    private boolean sideBySide;

    public DiffOpts() {
        this.init();
    }

    public DiffOpts(String opts) {
        this.init();
        this.parseOptions(opts);
    }

    private void init() {
        this.whitespaceOpts = WhitespaceOpts.IgnoreNone;
        this.ignoreBlankLines = false;
    }

    private void parseOptions(String opts) {
        if (opts == null) {
            return;
        }
        if (opts.indexOf("B") != -1) {
            this.ignoreBlankLines = true;
        }
        if (opts.indexOf("b") != -1) {
            this.whitespaceOpts = WhitespaceOpts.IgnoreSignificant;
        }
        if (opts.indexOf("w") != -1) {
            this.whitespaceOpts = WhitespaceOpts.IgnoreAll;
        }
    }

    public String getOptions() {
        return this.getBlankLineParam() + this.getWhitespaceParam();
    }

    public void setWhitespaceOpts(WhitespaceOpts opts) {
        this.whitespaceOpts = opts;
    }

    public boolean isIgnoreAllWhitespace() {
        return this.whitespaceOpts == WhitespaceOpts.IgnoreAll;
    }

    public boolean isIgnoreSignificantWhitespace() {
        return this.whitespaceOpts == WhitespaceOpts.IgnoreSignificant;
    }

    public boolean isIgnoreNoWhitespace() {
        return this.whitespaceOpts == WhitespaceOpts.IgnoreNone;
    }

    public void setIgnoreBlankLines(boolean ignoreBlankLines) {
        this.ignoreBlankLines = ignoreBlankLines;
    }

    public boolean isIgnoreBlankLines() {
        return this.ignoreBlankLines;
    }

    public void setSoftWrap(boolean softWrap) {
        this.softWrap = softWrap;
    }

    public boolean softWrap() {
        return this.softWrap;
    }

    public void setSideBySide(boolean sideBySide) {
        this.sideBySide = sideBySide;
    }

    public boolean sideBySide() {
        return this.sideBySide;
    }

    public String getBlankLineParam() {
        return this.ignoreBlankLines ? "B" : "";
    }

    public String getWhitespaceParam() {
        if (this.whitespaceOpts == WhitespaceOpts.IgnoreSignificant) {
            return "b";
        }
        if (this.whitespaceOpts == WhitespaceOpts.IgnoreAll) {
            return "w";
        }
        return "";
    }

    public String toString() {
        return "wsOpts: " + (Object)((Object)this.whitespaceOpts) + "; ignore blank lines: " + this.ignoreBlankLines + "; (" + this.getOptions() + "); sideBySide: " + this.sideBySide;
    }

    public static enum WhitespaceOpts {
        IgnoreAll,
        IgnoreSignificant,
        IgnoreNone;

    }
}

