/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.diff.view.DiffExplorer;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;

public class DiffHelper {
    public static HunkList getHunkList(IndexedLineReader lineReader1, IndexedLineReader lineReader2, DiffOpts opts) throws Exception {
        LineComparator lc = LineComparator.fromDiffOption(opts);
        HunkList hunks = Diff.diff(new TextFileDiffSequences(lineReader1, lineReader2, lc));
        lineReader1.seekLine(0);
        lineReader2.seekLine(0);
        return hunks;
    }

    public static FileDiffExplorer diffReaders(IndexedLineReader lineReader1, IndexedLineReader lineReader2, DiffInfo info, DiffOpts opts) throws IOException {
        HunkList hunks;
        LineComparator lc = LineComparator.fromDiffOption(opts);
        if (lineReader1.equals(lineReader2)) {
            lineReader1.scanRestOfFile();
            hunks = new HunkList(lineReader1.getTotalLines(), lineReader1.getTotalLines());
            lineReader1.seekLine(0);
        } else {
            hunks = Diff.diff(new TextFileDiffSequences(lineReader1, lineReader2, lc));
        }
        lineReader1.seekLine(0);
        lineReader2.seekLine(0);
        SyntaxDefinitions defs = AppConfig.getsConfig().getSyntaxDefinitions();
        SyntaxDefinition def = defs == null || info.getFileName() == null ? SyntaxDefinition.PASS_THRU : defs.getSyntaxDefinitionForFile(info.getFileName());
        return new FileDiffExplorer(lineReader1, lineReader2, hunks, info, def, opts);
    }

    public static DiffExplorer getDiffExp(ContentManager contentManager, Source source, FileRevisionExtraInfo frx, CrucibleRevision fromFr, CrucibleRevision toFr, String keywordOpts, DiffOpts diffOpts, int context) throws Exception {
        IndexedLineReader reader1;
        if (fromFr == null && toFr == null) {
            throw new Exception("Not enough revisions to diff");
        }
        if (fromFr == null) {
            fromFr = toFr;
        } else if (toFr == null) {
            toFr = fromFr;
        }
        Disposer disposer = Disposer.threadInstance();
        IndexedLineReader reader2 = contentManager.getContents(source, frx.getReview().getProject(), toFr, disposer, keywordOpts);
        if (fromFr.equals(toFr)) {
            reader1 = reader2;
            context = -1;
            diffOpts.setSideBySide(false);
        } else {
            reader1 = contentManager.getContents(source, frx.getReview().getProject(), fromFr, disposer, keywordOpts);
        }
        if (reader1 == null || reader2 == null) {
            return null;
        }
        String fileName = toFr.getFePath().getName();
        String fromRev = fromFr.getRevision();
        String toRev = toFr.getRevision();
        if (toFr.isDeletion() != null && toFr.isDeletion().booleanValue()) {
            toRev = null;
        }
        DiffInfo diffInfo = new DiffInfo(source.getName(), fileName, fromFr.getPath(), fromRev, toFr.getPath(), toRev);
        FileDiffExplorer diffExp = DiffHelper.diffReaders(reader1, reader2, diffInfo, diffOpts);
        diffExp.setContextLines(context);
        return diffExp;
    }

    private static void addToDisposer(Disposer disposer, IndexedLineReader r2) {
        if (r2 != null) {
            disposer.add(r2);
        }
    }

    public static HunkList getHunkList(ContentManager contentManager, Source source, FileRevisionExtraInfo frx, CrucibleRevision fromFr, CrucibleRevision toFr, String keywordOpts, DiffOpts diffOpts, int context) throws Exception {
        if (Logs.isDebugMode()) {
            Logs.APP_LOG.debug((Object)("Getting diff hunk list for " + fromFr + " to " + toFr));
        }
        if (fromFr == null || toFr == null || fromFr.equals(toFr)) {
            return null;
        }
        Disposer disposer = Disposer.threadInstance();
        IndexedLineReader reader1 = contentManager.getContents(source, frx.getReview().getProject(), fromFr, disposer, keywordOpts);
        IndexedLineReader reader2 = contentManager.getContents(source, frx.getReview().getProject(), toFr, disposer, keywordOpts);
        if (reader1 == null || reader2 == null) {
            return null;
        }
        return DiffHelper.getHunkList(reader1, reader2, diffOpts);
    }
}

