/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.X;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.o;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class RevInfoEAV {
    public static final I ENTITY = CommonSchema.RevInfo.ENTITY;
    public static final I E_ISCSMARKER_TO_REVID = EAV.E_ISCSMARKER_TO_REVID;
    public static final I E_CSTODO_TO_REVID = EAV.E_CSTODO_TO_REVID;
    public static final p A_ISCSMARKER = new p(1003L);
    public static final p A_REVID = new p(1004L);
    public static final p A_STATE = new p(1005L);
    public static final p A_CSTODO = new p(1006L);
    public static final X INV_ISCSMARKER = new X(EAV.SCHEMA, ENTITY, A_ISCSMARKER, E_ISCSMARKER_TO_REVID, A_REVID);
    public static final o INV_CSTODO = new o(EAV.SCHEMA, E_CSTODO_TO_REVID, A_CSTODO);
    private final InfinityDbHandle dbh;
    private final CommonRevInfoDAO commonDao;
    private final CommonDirInfoDAO dirDao;

    public RevInfoEAV(InfinityDbHandle dbh, CommonStringTables commonStringTables, boolean caseSensitive, LicenseEnforcer licenseEnforcer) throws DbException {
        this.dbh = dbh;
        this.commonDao = new CommonRevInfoDAO(dbh, commonStringTables, false, caseSensitive, licenseEnforcer);
        this.dirDao = new CommonDirInfoDAO(dbh, commonStringTables, caseSensitive);
    }

    public CvsRevInfo load(RevInfoKey key) throws IOException, DbException {
        int revid = this.commonDao.getRevId(key);
        if (revid == -1) {
            return null;
        }
        return this.load(revid);
    }

    public CvsRevInfo load(int revid) throws IOException, DbException {
        if (!this.commonDao.exists(revid)) {
            return null;
        }
        CvsRevInfo info = new CvsRevInfo();
        try {
            this.commonDao.load(revid, info);
            EavEntityCu ecu = this.makeEav(revid);
            info.setState(ecu.getString(A_STATE, null));
            info.setChangeSetId(ecu.getString(CommonSchema.RevInfo.A_CSID, null));
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Exception", (Throwable)e2);
            info = null;
        }
        return info;
    }

    public void update(RcsFileHistory history) throws IOException, DbException, LicensePolicyException {
        long t0 = System.currentTimeMillis();
        ArrayList<RcsRevisionInfo> revs = this.historyInAncestorOrder(history);
        for (RcsRevisionInfo r2 : revs) {
            this.update(r2);
        }
        long t1 = System.currentTimeMillis();
        for (RcsRevisionInfo r3 : revs) {
            int revid = r3.getRevID();
            this.commonDao.updateTagData(revid, r3.getTags());
        }
        if (Logs.APP_LOG.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)("updated " + history.getPath() + " in " + (t2 - t0) + "ms, including tags in " + (t2 - t1) + "ms"));
        }
    }

    private ArrayList<RcsRevisionInfo> historyInAncestorOrder(RcsFileHistory history) {
        ArrayList<RcsRevisionInfo> l2 = new ArrayList<RcsRevisionInfo>(history.getRevisions());
        Collections.sort(l2, new Comparator<RcsRevisionInfo>(){

            @Override
            public int compare(RcsRevisionInfo a2, RcsRevisionInfo b2) {
                return a2.getCvsRevision().compareTo(b2.getCvsRevision());
            }
        });
        return l2;
    }

    private boolean update(RcsRevisionInfo ri) throws IOException, DbException, LicensePolicyException {
        int revid;
        ac db = this.dbh.get();
        RevInfoKey rk = ri.getRevInfoKey();
        boolean existing = this.commonDao.exists(rk);
        AncestorLink ancestorLink = null;
        if (ri.getAncestor() != null) {
            int aid = this.commonDao.getRevId(ri.getAncestor().getRevInfoKey());
            ancestorLink = new AncestorLink(ri.getAncestorType(), aid);
        }
        if (!existing) {
            revid = this.commonDao.insertNew(ri, ancestorLink, true, false);
            ri.setRevID(revid);
            this.commonDao.addBranchpoints(revid, ancestorLink, ri.getBranches());
            EavEntityCu ecu = this.makeEav(revid);
            ecu.updateString(A_STATE, ri.getState());
            INV_CSTODO.c(db, y.a().b(ri.getDate()), y.a().b((long)revid));
        } else {
            revid = this.commonDao.getRevId(rk);
            ri.setRevID(revid);
            this.commonDao.addBranchpoints(revid, ancestorLink, ri.getBranches());
        }
        ri.setNewlyAdded(!existing);
        return existing;
    }

    public Path[] listFiles(Path dir) throws DbException {
        Collection<Path> paths = this.dirDao.listFiles(dir);
        return paths.toArray(new Path[paths.size()]);
    }

    public Path[] listDirs(Path dir) throws DbException {
        Collection<Path> paths = this.dirDao.listDirs(dir);
        return paths.toArray(new Path[paths.size()]);
    }

    public void updateChangeset(FileRevision ri, CvsCSID csid) throws DbException {
        if (Logs.APP_LOG.isDebugEnabled()) {
            if (ri != null) {
                Logs.APP_LOG.debug((Object)("updating csid '" + csid + "' with FileRevision '" + ri.getRevID() + "'"));
            } else {
                Logs.APP_LOG.debug((Object)("updating csid '" + csid + "' with null FileRevision"));
            }
        }
        Preconditions.checkNotNull((Object)ri);
        try {
            ac db = this.dbh.get();
            int revid = ri.getRevID();
            this.commonDao.updateCSID(revid, csid.toString());
            INV_CSTODO.d(db, y.a().b(ri.getDate()), y.a().b((long)revid));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setAsChangesetMarker(CvsRevInfo marker) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(marker.getRevID());
        ecu.updateBooleanInversion(INV_ISCSMARKER, true);
    }

    public CvsCSID getChangeSet(int revid) throws IOException, DbException {
        EavEntityCu ecu = this.makeEav(revid);
        String csid = ecu.getString(CommonSchema.RevInfo.A_CSID, null);
        return csid == null ? null : CvsCSID.parse(csid);
    }

    public boolean changesetContainsPath(CvsCSID csid, Path path) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a().b(csid.toString());
        y val = y.a();
        while (CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val)) {
            int revid = (int)val.v(0);
            RevInfoKey key = this.commonDao.getKey(revid);
            if (!path.equals(key.getPath())) continue;
            return true;
        }
        return false;
    }

    public IntList getChangeSetRevids(CvsCSID csid) throws IOException, DbException {
        ac db = this.dbh.get();
        IntArrayList result = new IntArrayList();
        y cu = y.a().b(csid.toString());
        y val = y.a();
        while (CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val)) {
            int revid = (int)val.v(0);
            result.add(revid);
        }
        return result;
    }

    public RevInfoKey getKey(int revid) throws DbException {
        return this.commonDao.getKey(revid);
    }

    private EavEntityCu makeEav(int revid) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a(revid);
        return new EavEntityCu(db, ENTITY, cu);
    }

    public int findRevID(RevInfoKey revkey) throws DbException {
        return this.commonDao.getRevId(revkey);
    }

    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.commonDao;
    }
}

