/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.atlassian.fecru.util.ClassUtils;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.BranchDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.cache.CachedChangesetUpdater;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSet;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSetDAO;
import com.cenqua.fisheye.cvsrep.cache.CvsDirInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.DirInfoEAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.FileHistEAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.LazyFileRevisionInterceptor;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;

public class InfDbRevisionInfoCache
implements RevisionInfoCache {
    private CommonStringTables commonTables;
    private RevInfoEAV mRevInfoEAV;
    private DirInfoEAV mDirInfoEAV;
    private FileHistEAV mFileHistEAV;
    private CvsChangeSetDAO csDAO;
    private BranchDAO branchDAO;
    private Factory proxyFactory;
    private final IndexingContext indexingContext;
    private volatile Long lastModified;
    private boolean caseSensitive;
    private final LicenseEnforcer licenseEnforcer;
    private final RepositoryConfig repositoryConfig;
    private final InfinityDbHandle dbh;

    public InfDbRevisionInfoCache(RepositoryConfig repositoryConfig, IndexingContext indexingContext, InfinityDbHandle dbh, LicenseEnforcer licenseEnforcer) {
        this.repositoryConfig = repositoryConfig;
        this.indexingContext = indexingContext;
        this.dbh = dbh;
        this.licenseEnforcer = licenseEnforcer;
    }

    @Override
    public void commit() throws DbException {
        try {
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void dispose() throws Exception {
        this.commit();
    }

    protected void insert(y cursor) throws DbException {
        try {
            ac db = this.dbh.get();
            db.b(cursor);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected void update(y cursor, int pl) throws DbException {
        try {
            ac db = this.dbh.get();
            db.e(cursor, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected boolean next(y cursor, int pl) throws DbException {
        try {
            ac db = this.dbh.get();
            return db.a(cursor, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLongValue(I entityClass, String key, long value) throws DbException {
        y cu = y.a();
        try {
            cu.a(entityClass).b(key);
            int p1 = cu.e();
            cu.b(value);
            this.update(cu, p1);
        }
        finally {
            y.c(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongValue(I entityClass, String key, long defaultValue) throws DbException {
        y cu = y.a();
        try {
            cu.a(entityClass).b(key);
            int p1 = cu.e();
            if (this.next(cu, p1)) {
                long v2;
                long l2 = v2 = cu.v(p1);
                return l2;
            }
            long l3 = defaultValue;
            return l3;
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public void setBranchDAO(BranchDAO branchDAO) {
        this.branchDAO = branchDAO;
    }

    public void open() throws IOException, DbException {
        this.commonTables = new CommonStringTables(this.getInfDb());
        this.mRevInfoEAV = new RevInfoEAV(this.getInfDb(), this.commonTables, this.caseSensitive, this.licenseEnforcer);
        this.mDirInfoEAV = new DirInfoEAV(this.getInfDb(), this.commonTables, this.caseSensitive);
        this.mFileHistEAV = new FileHistEAV(this.getInfDb(), this.commonTables.pathDB, this.mRevInfoEAV);
        this.csDAO = new CvsChangeSetDAO(this.repositoryConfig.getStatus(), this.getInfDb(), this.commonTables, this, this.licenseEnforcer);
    }

    @Override
    public void touch() throws DbException {
        long ts = System.currentTimeMillis();
        this.indexingContext.getRepositoryModificationTracker().setModified(this.getRepName(), ts);
        this.setLastModified(ts);
    }

    FileHistEAV getFileHistEAV() {
        return this.mFileHistEAV;
    }

    @Override
    public long getLastModified() throws DbException {
        Long lm = this.lastModified;
        if (lm == null) {
            this.lastModified = lm = Long.valueOf(this.getLongProperty("LAST_MODIFIED", -1L));
        }
        return lm;
    }

    private void setLastModified(long v2) throws DbException {
        this.setLongValue(EAV.PROP_STORE, "LAST_MODIFIED", v2);
        this.lastModified = v2;
    }

    @Override
    public void putDirInfo(CvsDirInfo d2) throws DbException {
        try {
            this.mDirInfoEAV.update(d2);
            this.touch();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public DirInfo findDirInfo(Path path) throws DbException {
        return this.mDirInfoEAV.load(path);
    }

    @Override
    public CvsDirInfo findCvsDirInfo(Path path) throws DbException {
        try {
            return this.mDirInfoEAV.loadCvsInfo(path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        return this.mDirInfoEAV.exists(path);
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        return this.mRevInfoEAV.listDirs(dir);
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        return this.mRevInfoEAV.listFiles(dir);
    }

    @Override
    public long getLongProperty(String key, long defaultValue) throws DbException {
        return this.getLongValue(EAV.PROP_STORE, key, defaultValue);
    }

    @Override
    public void index(List<RcsFileHistoryFactory.Result> histories) throws DbException, LicensePolicyException {
        try {
            for (RcsFileHistoryFactory.Result history : histories) {
                this.mRevInfoEAV.update(history.getHistory());
                this.mFileHistEAV.update(history.getHistory());
            }
            this.touch();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsRevInfo findRevInfo(RevInfoKey key) throws DbException {
        try {
            return this.mRevInfoEAV.load(key);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public FileHistory findFileHistory(Path path) throws DbException {
        try {
            return this.mFileHistEAV.load(path, this.repositoryConfig.getName());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        try {
            return this.mFileHistEAV.exists(path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsRevInfo findRevInfo(int revid) throws DbException {
        try {
            return this.mRevInfoEAV.load(revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsRevInfo load(int revid) throws DbException {
        return this.findRevInfo(revid);
    }

    @Override
    public void appendToChangeSet(CvsCSID csid, List<CvsRevInfo> revInfos) throws DbException {
        for (FileRevision fileRevision : revInfos) {
            this.mRevInfoEAV.updateChangeset(fileRevision, csid);
        }
        this.touch();
    }

    @Override
    public CvsCSID createNewChangeSet(CvsRevInfo marker) throws DbException {
        try {
            CvsCSID id;
            boolean found;
            int count = 0;
            while (found = this.changesetExists(id = new CvsCSID(marker.getBranch(), marker.getAuthor(), marker.getDate(), count++))) {
            }
            CvsChangeSet cs = new CvsChangeSet(id, this.csDAO, (RevisionInfoCache)this);
            cs.setAuthor(marker.getAuthor());
            cs.setComment(marker.getComment());
            cs.setDate(marker.getDate());
            cs.setBranch(marker.getBranch());
            try {
                this.csDAO.store(cs);
            }
            catch (LicensePolicyException e2) {
                throw new DbException(e2);
            }
            Branch branch = new Branch(marker.getBranch(), id.toString(), null);
            this.branchDAO.store(branch, true);
            this.mRevInfoEAV.setAsChangesetMarker(marker);
            this.touch();
            return id;
        }
        catch (IOException e3) {
            throw new DbException(e3);
        }
    }

    private boolean changesetExists(CvsCSID id) throws DbException {
        return this.csDAO.exists(id.toString());
    }

    @Override
    public CvsCSID getChangeSetId(int revid) throws DbException {
        try {
            return this.mRevInfoEAV.getChangeSet(revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsCSID getChangeSetId(RevInfoKey rk) throws DbException {
        try {
            int revid = this.mRevInfoEAV.findRevID(rk);
            return this.mRevInfoEAV.getChangeSet(revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public List<String> getSimilarChangeSetIds(CvsCSID patternID) throws DbException {
        CvsCSID id;
        LinkedList<String> result = new LinkedList<String>();
        String branch = patternID.getBranch();
        String author = patternID.getAuthor();
        long date = patternID.getDate();
        int count = 0;
        while (this.changesetExists(id = new CvsCSID(branch, author, date, count++))) {
            String idstr = id.toString();
            result.add(idstr);
        }
        return result;
    }

    @Override
    public IntList getChangeSet(CvsCSID csid) throws DbException {
        if (csid == null) {
            return new IntArrayList(1);
        }
        try {
            return this.mRevInfoEAV.getChangeSetRevids(csid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean changesetContainsPath(CvsCSID csid, Path path) throws DbException {
        try {
            return this.mRevInfoEAV.changesetContainsPath(csid, path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getCommentId(String comment) throws DbException {
        return this.commonTables.commentDB.find(comment);
    }

    @Override
    public boolean scanForChangesets(long noLaterThan, RepositoryStatus st, Set<CvsCSID> changesets) throws DbException {
        CachedChangesetUpdater cupdater = new CachedChangesetUpdater(st, this.getInfDb(), this);
        boolean foundChanges = false;
        do {
            cupdater.processSomeChangesets(noLaterThan, changesets);
            foundChanges |= cupdater.foundChanges();
            this.commit();
        } while (cupdater.foundChanges());
        this.touch();
        return foundChanges;
    }

    @Override
    public InfinityDbHandle getInfDb() {
        return this.dbh;
    }

    @Override
    public CommonStringTables getCommonStringTables() {
        return this.commonTables;
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.mRevInfoEAV.getCommonRevInfoDAO();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String getHeadRevision(Path path) throws DbException {
        try {
            return this.mFileHistEAV.getHeadRevision(path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public String getRepName() {
        return this.repositoryConfig.getName();
    }

    @Override
    public IntList getChangeSetRevids(String csid) throws DbException {
        return this.getCommonRevInfoDAO().getChangeSetRevids(csid);
    }

    @Override
    public RevInfoKey getKey(int revid) throws DbException {
        return this.getCommonRevInfoDAO().getKey(revid);
    }

    private Factory getProxyFactory() {
        if (this.proxyFactory == null) {
            this.proxyFactory = ClassUtils.createEnhancer(CvsRevInfo.class, new LazyFileRevisionInterceptor<CvsRevInfo>(-1, this));
        }
        return this.proxyFactory;
    }

    @Override
    public CvsRevInfo loadLazy(int revid) throws DbException {
        if (this.getCommonRevInfoDAO().exists(revid)) {
            return (CvsRevInfo)this.getProxyFactory().newInstance(new Callback[]{new LazyFileRevisionInterceptor<CvsRevInfo>(revid, this), NoOp.INSTANCE});
        }
        return null;
    }

    @Override
    public CvsRevInfo loadLazy(RevInfoKey revKey) throws DbException {
        int revid = this.getCommonRevInfoDAO().getRevId(revKey);
        if (revid != -1) {
            return (CvsRevInfo)this.getProxyFactory().newInstance(new Callback[]{new LazyFileRevisionInterceptor<CvsRevInfo>(revid, revKey, this), NoOp.INSTANCE});
        }
        return null;
    }

    @Override
    public int insertNew(CvsRevInfo revInfo, AncestorLink ancestorLink, boolean storeDiffs) throws DbException, LicensePolicyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getId(RevInfoKey revKey) throws DbException {
        return this.getCommonRevInfoDAO().getRevId(revKey);
    }

    @Override
    public CvsRevInfo getDiffRevision(CvsRevInfo rev) throws DbException {
        if (rev != null && rev.getDiffRevision() != null) {
            return this.findRevInfo(rev.getDiffRevision());
        }
        return null;
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate, boolean predecessorFirst) throws DbException {
        return this.getCommonRevInfoDAO().searchAncestors(revInfoKey, predicate, predecessorFirst);
    }

    @Override
    public Iterable<CvsRevInfo> getRevisionIterable(final String csid) throws DbException {
        return new Iterable<CvsRevInfo>(){

            @Override
            public Iterator<CvsRevInfo> iterator() {
                return InfDbRevisionInfoCache.this.getCommonRevInfoDAO().getRevisionIterator(csid, InfDbRevisionInfoCache.this);
            }
        };
    }

    @Override
    public CvsRevInfo searchChangeSetRevisions(String csid, final Predicate<FileRevision> predicate) throws DbException {
        final CvsRevInfo[] result = new CvsRevInfo[1];
        this.getCommonRevInfoDAO().searchChangeSetRevids(csid, new Predicate<Integer>(){

            public boolean apply(Integer input) {
                CvsRevInfo revInfo = InfDbRevisionInfoCache.this.loadLazy(input);
                if (predicate.apply((Object)revInfo)) {
                    result[0] = revInfo;
                    return true;
                }
                return false;
            }
        });
        return result[0];
    }

    @Override
    public void visitChangeSetRevisions(String csid, final StoppableVisitor<FileRevision> visitor) throws DbException {
        this.getCommonRevInfoDAO().searchChangeSetRevids(csid, new Predicate<Integer>(){

            public boolean apply(Integer input) {
                visitor.visit(InfDbRevisionInfoCache.this.loadLazy(input));
                return false;
            }
        });
    }

    @Override
    public void visitChangeSetRevisions(String csid, final Visitor<FileRevision> visitor, final Predicate<Integer> breakCondition) throws DbException {
        if (visitor != null && csid != null) {
            this.getCommonRevInfoDAO().searchChangeSetRevids(csid, new Predicate<Integer>(){

                public boolean apply(Integer revid) {
                    visitor.visit(InfDbRevisionInfoCache.this.loadLazy(revid));
                    return breakCondition.apply((Object)revid);
                }
            });
        }
    }

    @Override
    public Iterable<Path> getPathsInChangeset(String csid) {
        y csCu = y.a(CommonSchema.E_CSID_TO_REVID).b(csid);
        InfDbIterable<Path> mayHaveNulls = new InfDbIterable<Path>(this.dbh, csCu, csCu.e()){
            private y revCu;
            {
                this.revCu = y.a();
            }

            @Override
            public Path getElement(y cu, int elementOffset) throws IOException, DbException {
                long revid = cu.v(elementOffset);
                this.revCu.f().a(CommonSchema.RevInfo.ENTITY).b(revid).a(CommonSchema.RevInfo.A_PATHID);
                int revOffSet = this.revCu.e();
                if (InfDbRevisionInfoCache.this.getInfDb().get().a(this.revCu, revOffSet)) {
                    long pathId = this.revCu.v(revOffSet);
                    return new Path(((InfDbRevisionInfoCache)InfDbRevisionInfoCache.this).commonTables.pathDB.get(pathId));
                }
                return null;
            }
        };
        return Iterables.filter((Iterable)mayHaveNulls, (Predicate)Predicates.notNull());
    }

    public CvsChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    public AncestorLink getAncestorLink(int revid) throws DbException {
        return this.getCommonRevInfoDAO().getAncestorOf(revid);
    }

    @Override
    public boolean isDead(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isDeleted(revid);
    }

    @Override
    public boolean isAdded(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isAdded(revid);
    }

    @Override
    public boolean isBinary(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isBinary(revid);
    }

    @Override
    public boolean isOversize(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isOversize(revid);
    }

    @Override
    public boolean isFile(int revid) {
        return this.getCommonRevInfoDAO().isFile(revid);
    }

    @Override
    public boolean isDir(int revid) {
        return this.getCommonRevInfoDAO().isDir(revid);
    }

    @Override
    public boolean isMove(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isMoved(revid);
    }

    @Override
    public boolean isMetadataOnly(int revid) throws DbException {
        return false;
    }

    @Override
    public boolean isCopy(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isCopy(revid);
    }

    @Override
    public boolean isModify(int revid) throws DbException {
        return this.getCommonRevInfoDAO().isModify(revid);
    }

    @Override
    public List<String> getBranchPoints(int revid) throws DbException {
        return this.getCommonRevInfoDAO().getBranchPoints(revid);
    }

    @Override
    public long getDate(int revid) throws DbException {
        return this.getCommonRevInfoDAO().getDate(revid);
    }

    @Override
    public LineCountState getLineCountState(int revid) {
        return this.getCommonRevInfoDAO().getLineCountState(revid);
    }

    @Override
    public String getAuthor(int revid) {
        return this.getCommonRevInfoDAO().getAuthorOfRevision(revid);
    }

    @Override
    public String getDisplayRevision(int revid) {
        return this.getRevision(revid);
    }

    @Override
    public String getRevision(int revid) {
        EavEntityCu eavEntityCu = this.getCommonRevInfoDAO().makeEav(revid);
        y cu = y.a();
        try {
            eavEntityCu.getValue(CommonSchema.RevInfo.A_REVKEY, cu);
            int revOffset = cu.w(0);
            String string = cu.e() > revOffset ? cu.m(revOffset) : null;
            return string;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public Path getLogicalPath(Path path) {
        return path;
    }
}

