/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsFileHistory;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FileHistEAV {
    public static final I ENTITY = EAV.FILE_INFO;
    public static final p A_ISBINARY = new p(1L);
    public static final p A_EXPAND = new p(2L);
    public static final p A_HEAD = new p(3L);
    public static final p A_MAINBRANCH = new p(4L);
    public static final p A_REVISIONS = new p(5L);
    private final InfinityDbHandle dbh;
    private final UniqueStringTable pathDB;
    private final RevInfoEAV revInfoEav;

    public FileHistEAV(InfinityDbHandle dbh, UniqueStringTable pathDB, RevInfoEAV revInfoEav) {
        this.dbh = dbh;
        this.pathDB = pathDB;
        this.revInfoEav = revInfoEav;
    }

    public void update(RcsFileHistory history) throws IOException, DbException {
        long pid = this.pathDB.add(history.getPath().getPath());
        EavEntityCu ecu = this.makeEav(pid);
        ecu.updateBoolean(A_ISBINARY, history.isBinary());
        KeywordExpansion expand = history.getExpand();
        ecu.updateString(A_EXPAND, expand == null ? null : expand.getName());
        ecu.updateString(A_HEAD, history.getHead());
        ecu.updateString(A_MAINBRANCH, history.getMainBranch());
        ecu.deleteValues(A_REVISIONS);
        for (RcsRevisionInfo info : history.getRevisions()) {
            ecu.addLong(A_REVISIONS, info.getRevID());
        }
    }

    public CvsFileHistory load(Path path, String repositoryName) throws IOException, DbException {
        long pid = this.pathDB.find(path.getPath());
        if (pid == -1L) {
            return null;
        }
        EavEntityCu ecu = this.makeEav(pid);
        if (!ecu.exists()) {
            return null;
        }
        CvsFileHistory history = new CvsFileHistory(ecu.getBoolean(A_ISBINARY, false), ecu.getString(A_EXPAND, null), path, ecu.getString(A_HEAD, null), ecu.getString(A_MAINBRANCH, null), this.loadRevisions(ecu, repositoryName));
        return history;
    }

    public boolean exists(Path path) throws IOException, DbException {
        long pid = this.pathDB.find(path.getPath());
        if (pid == -1L) {
            return false;
        }
        return this.makeEav(pid).exists();
    }

    private Map<String, CommonFileRevision> loadRevisions(EavEntityCu ecu, String repositoryName) throws IOException, DbException {
        HashMap<String, CommonFileRevision> map = new HashMap<String, CommonFileRevision>();
        LongList revids = ecu.getLongs(A_REVISIONS);
        for (int i2 = 0; i2 < revids.size(); ++i2) {
            int revid = (int)revids.getLong(i2);
            CvsRevInfo info = this.revInfoEav.load(revid);
            if (info == null) continue;
            map.put(info.getRevision(), info);
        }
        return map;
    }

    private EavEntityCu makeEav(long pid) throws IOException, DbException {
        y cu = y.a(pid);
        return new EavEntityCu(this.dbh.get(), ENTITY, cu);
    }

    public String getHeadRevision(Path path) throws IOException, DbException {
        long pid = this.pathDB.find(path.getPath());
        if (pid == -1L) {
            return null;
        }
        return this.makeEav(pid).getString(A_HEAD, null);
    }
}

