/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.cache.CvsDirInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.p;
import java.io.IOException;

public class DirInfoEAV {
    public static final I ENTITY = EAV.DIR_INFO_EXTRA;
    public static final p A_FILECOUNT = new p(1001L);
    public static final p A_YOUNGEST_TS = new p(1002L);
    private final InfinityDbHandle dbh;
    private final UniqueStringTable dirDB;
    private final CommonDirInfoDAO dirDao;

    public DirInfoEAV(InfinityDbHandle dbh, CommonStringTables tables, boolean caseSensitive) {
        this.dbh = dbh;
        this.dirDB = tables.pathDB;
        this.dirDao = new CommonDirInfoDAO(dbh, tables, caseSensitive);
    }

    public DirInfo load(Path key) throws DbException {
        return this.dirDao.load(key);
    }

    public CvsDirInfo loadCvsInfo(Path key) throws IOException, DbException {
        long pathID = this.dirDB.find(key.getPath());
        EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, pathID);
        if (!ecu.exists()) {
            return null;
        }
        CvsDirInfo di = new CvsDirInfo(key);
        di.setFileCount(ecu.getInt(A_FILECOUNT, di.getFileCount()));
        di.setYoungestTimestamp(ecu.getLong(A_YOUNGEST_TS, di.getYoungestTimestamp()));
        return di;
    }

    public boolean exists(Path key) throws DbException {
        try {
            long pathID = this.dirDB.find(key.getPath());
            EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, pathID);
            return ecu.exists();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void update(CvsDirInfo di) throws IOException, DbException {
        this.dirDao.addDirToParent(di.getPath());
        long pathID = this.dirDB.add(di.getPath().getPath());
        EavEntityCu ecu = new EavEntityCu(this.dbh.get(), ENTITY, pathID);
        ecu.updateInt(A_FILECOUNT, di.getFileCount());
        ecu.updateLong(A_YOUNGEST_TS, di.getYoungestTimestamp());
    }
}

