/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.util.DateHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PartialCvsCSID {
    private static final Pattern PARSE_PROG = Pattern.compile("^([^:]+)?:([^:]+)?:(\\d\\d\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(:(\\d+))?$");
    private final String mBranch;
    private final String mAuthor;
    private final long mDate;

    public PartialCvsCSID(String branch, String author, long date) {
        this.mBranch = branch;
        this.mAuthor = author;
        this.mDate = date;
    }

    public String getBranch() {
        return this.mBranch;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public long getDate() {
        return this.mDate;
    }

    public static PartialCvsCSID parse(String str) {
        Matcher m2 = PARSE_PROG.matcher(str);
        if (m2.matches()) {
            String br = PartialCvsCSID.nullIfEmpty(m2.group(1));
            String auth = PartialCvsCSID.nullIfEmpty(m2.group(2));
            int[] time = new int[]{Integer.parseInt(m2.group(3)), Integer.parseInt(m2.group(4)), Integer.parseInt(m2.group(5)), Integer.parseInt(m2.group(6)), Integer.parseInt(m2.group(7)), Integer.parseInt(m2.group(8))};
            long date = DateHelper.componentsToTime(time);
            String ucStr = m2.group(10);
            int uc = ucStr == null ? 0 : Integer.parseInt(m2.group(10));
            return new PartialCvsCSID(br, auth, date);
        }
        return null;
    }

    private static String nullIfEmpty(String s2) {
        if (s2 == null) {
            return s2;
        }
        return (s2 = s2.trim()).equals("") ? null : s2;
    }
}

