/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.atlassian.fecru.search.index.model.DiffDocInfo;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.cenqua.fisheye.cvsrep.ChangeTree;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexWriter;

public class DiffTextIndexer {
    private final RcsFileHistoryFactory.Result result;
    private List<ChangeTree.DiffTextReaders> readers = null;

    public DiffTextIndexer(RcsFileHistoryFactory.Result result) {
        this.result = result;
    }

    public void openReaders() {
        this.readers = this.result.getTree().getNewDiffTextReaders(this.result.getHistory().getRevisions());
    }

    public void closeReaders() {
        if (this.readers != null) {
            for (ChangeTree.DiffTextReaders reader : this.readers) {
                IOHelper.close(reader.getAdded());
                IOHelper.close(reader.getRemoved());
            }
        }
    }

    public void indexDiffText(LuceneConnection<LuceneIndexes> con) throws DbException {
        for (final ChangeTree.DiffTextReaders reader : this.readers) {
            con.withWriter(LuceneIndexes.DIFFTEXT, new LuceneConnection.WriterAction<Void>(){

                @Override
                public Void perform(IndexWriter writer) throws IOException, DbException {
                    RcsRevisionInfo rev = reader.getRev();
                    Logs.APP_LOG.debug((Object)("indexing diff text " + rev.getRevInfoKey()));
                    DocInfoManager<DiffDocInfo> diffDocManager = new DocInfoManager<DiffDocInfo>(writer, null);
                    diffDocManager.addDoc(new DiffDocInfo(reader.getAdded(), reader.getRemoved(), rev.getPath(), rev.getChangeSetId(), rev.getRevID(), rev.getDate(), rev.getRevision()));
                    return null;
                }
            });
        }
    }
}

