/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.event.ChangesetsIndexedEvent;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CachedDirUpdater;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.cvsrep.cache.CvsHistoryChangeDetector;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.CommonRepositoryScanner;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.activity.ActivityLog;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Timer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.NDC;

public class CvsScanner
extends CommonRepositoryScanner<CvsCache> {
    private final CvsRepository rep;
    private final BlameAndLinecountCalculator blameAndLinecountCalculator;
    private final RevisionInfoCache revisionInfoCache;
    private final CvsHistoryChangeDetector mDetector;
    private int dirCount;
    private boolean foundChanges = false;
    private boolean licenseLimitReached;

    public CvsScanner(RepositoryConfig repositoryConfig, CvsCache repositoryCache, IndexingContext indexingContext, BlameAndLinecountCalculator blameAndLinecountCalculator) {
        super(repositoryConfig, indexingContext, repositoryCache);
        this.blameAndLinecountCalculator = blameAndLinecountCalculator;
        this.revisionInfoCache = ((CvsCache)this.cache).getRevisionInfoCache();
        this.rep = ((CvsCache)this.cache).getRepository();
        CvsScmConfig cvsConfig = (CvsScmConfig)repositoryConfig.getScmConfig();
        this.mDetector = new CvsHistoryChangeDetector(this, cvsConfig.getHistoryFile(), cvsConfig.getFullScanPeriod(), cvsConfig.getHistoryStripPrefix());
        this.mDetector.setCacheListener(((CvsCache)this.cache).getEventMulticaster());
    }

    protected boolean foundChanges() {
        return this.foundChanges;
    }

    protected void resetFoundChanges() {
        this.foundChanges = false;
    }

    public void requestFullscan() {
        Logs.APP_LOG.info((Object)("fullscan requested on " + this.rep.getName()));
        this.mDetector.requestFullscan();
    }

    protected void setLicensePolicyReached(boolean exceeded, LicensePolicyException e2) {
        if (!this.licenseLimitReached && exceeded) {
            Logs.APP_LOG.warn((Object)"License limit reached", (Throwable)e2);
        }
        this.licenseLimitReached = exceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullSlurp(long slurpStartTime) throws DbException {
        if (this.status.isStopRequested()) {
            return;
        }
        try {
            if (!this.status.isInitialIndexingComplete()) {
                Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] starting initial scan of repository"));
            }
            Logs.APP_LOG.info((Object)("processing /" + this.getRepoName()));
            long t0 = System.currentTimeMillis();
            this.dirCount = 0;
            try {
                this.scanDirAndFiles(Path.ROOT);
                this.setLicensePolicyReached(false, null);
            }
            catch (LicensePolicyException e2) {
                this.setLicensePolicyReached(true, e2);
            }
            long t1 = System.currentTimeMillis();
            Logs.APP_LOG.info((Object)("done " + this.rep.getName() + ", slurp time = " + (t1 - t0) + "ms"));
            if (this.status.isStopRequested()) {
                return;
            }
            this.scanChangesets(slurpStartTime, this.revisionInfoCache);
            long t2 = System.currentTimeMillis();
            if (!this.status.isInitialIndexingComplete()) {
                Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] finished initial scan of repository " + "(visited " + this.dirCount + " directories) in " + (t2 - t0) / 1000L + "s"));
            }
            this.blameAndLinecountCalculator.calcBlame(false);
            this.revisionInfoCache.commit();
            if (this.foundChanges) {
                this.indexingContext.getEventPublisher().publish((Object)new ChangesetsIndexedEvent(this.getRepoName()));
            }
        }
        finally {
            this.status.setMessage("");
        }
    }

    protected void scanForChangesets(long slurpStartTime) throws DbException {
        if (this.status.isStopRequested()) {
            return;
        }
        try {
            this.scanChangesets(slurpStartTime, this.revisionInfoCache);
            this.revisionInfoCache.commit();
            if (this.foundChanges) {
                this.indexingContext.getEventPublisher().publish((Object)new ChangesetsIndexedEvent(this.getRepoName()));
            }
        }
        finally {
            this.status.setMessage("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanChangesets(long slurpStartTime, RevisionInfoCache aDB) throws DbException {
        long t0 = System.currentTimeMillis();
        HashSet<CvsCSID> changesets = new HashSet<CvsCSID>();
        Disposer.pushThreadInstance();
        try {
            this.status.setMessage("scanning for changesets");
            this.foundChanges |= aDB.scanForChangesets(slurpStartTime, this.status, changesets);
            if (this.foundChanges) {
                for (CvsCSID csid : changesets) {
                    ((CvsCache)this.cache).updateChangesetAncestry(csid);
                    ((CvsCache)this.cache).addBranchPointBranches(csid);
                }
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
        long t1 = System.currentTimeMillis();
        Logs.APP_LOG.debug((Object)(this.rep.getName() + ": changesets scanned in " + (t1 - t0) + "ms"));
        if (changesets.size() > 0) {
            ((CvsCache)this.cache).getIndex().indexMetaData(changesets, (CvsCache)this.cache);
            aDB.touch();
        }
    }

    protected void scanDir(Path aPath) throws DbException, LicensePolicyException {
        if (this.status.isStopRequested()) {
            return;
        }
        try {
            if (!this.rep.isDir(aPath)) {
                return;
            }
            this.updateDir(aPath);
            this.foundChanges = true;
            this.revisionInfoCache.commit();
        }
        finally {
            this.status.setMessage("");
        }
    }

    private boolean scanDirAndFiles(Path aPath) throws DbException, LicensePolicyException {
        Path[] dirs;
        ++this.dirCount;
        this.status.setMessage("processing " + this.rep.getName() + ":" + aPath.abbreviate(50) + " (" + this.dirCount + " dirs so far)");
        boolean updated = this.updateDir(aPath);
        for (Path child : dirs = this.rep.listDirs(aPath)) {
            if (this.status.isStopRequested()) {
                return updated;
            }
            updated |= this.scanDirAndFiles(child);
        }
        dirs = null;
        this.foundChanges = updated;
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDir(Path aPath) throws DbException, LicensePolicyException {
        boolean updated;
        ActivityLog activity = new ActivityLog("Scanning directory /" + aPath + " for changes");
        this.status.getRecentActivities().add(activity);
        Disposer.pushThreadInstance();
        try {
            long t0 = System.currentTimeMillis();
            CachedDirUpdater updater = new CachedDirUpdater(aPath, this.rep, (CvsCache)this.cache, this.status);
            updated = updater.scanPhase1();
            updater = null;
            long t1 = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)(" processed /" + this.rep.getName() + ":" + aPath + " in " + (t1 - t0) + "ms " + (updated ? "was updated" : "no change")));
        }
        finally {
            try {
                activity.finished();
                this.status.getRecentActivities().archive(activity);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
        this.foundChanges = updated;
        return updated;
    }

    @Override
    public void ping() {
        try {
            NDC.push((String)this.rep.getName());
            this.mDetector.ping();
        }
        finally {
            NDC.pop();
        }
    }

    @Override
    public void resetScmMetaData() {
        CrossRepLuceneIndex crossRepLuceneIndex = ((CvsCache)this.cache).getCrossRepoIndex();
        this.recreateChangesetIndex(null, EggTimer.UNLIMITED_TIMER);
        Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] Finished upgrading quicksearch metadata"));
        this.upgradeContentIndex();
        this.reindexChangesetComments(true);
        crossRepLuceneIndex.setRescanStatus(this.cache, -1L, false);
        this.status.setMessage("Reindexing metadata completed.");
    }

    private long recreateChangesetIndex(Long endChangesetIndex, EggTimer timer) {
        UniqueStringTable changeSetIdDB = ((CommonStringTables)((CvsCache)this.getCache()).getStringTables()).changeSetIdDB;
        endChangesetIndex = endChangesetIndex == null ? changeSetIdDB.getMaxId() : endChangesetIndex.longValue();
        long blockSize = 1000L;
        for (long endBatchIndex = endChangesetIndex.longValue(); endBatchIndex > -1L; endBatchIndex -= blockSize) {
            this.getStatus().throwOnStopRequested();
            long startBatchIndex = Math.max(endBatchIndex - blockSize + 1L, 1L);
            this.setStatusReindexingChangesets(endBatchIndex, startBatchIndex);
            ImmutableList.Builder changesetIdsBuilder = ImmutableList.builder();
            for (long id = endBatchIndex; id >= startBatchIndex; --id) {
                String changesetId = changeSetIdDB.get(id);
                if (changesetId == null) continue;
                changesetIdsBuilder.add((Object)changesetId);
            }
            ImmutableList changesetIds = changesetIdsBuilder.build();
            Timer indexingTimer = this.startIndexingTimer(startBatchIndex, endBatchIndex);
            ((CvsCache)this.cache).getIndex().reindexMetaData((Iterable<String>)changesetIds, (CvsCache)this.cache, true);
            this.stopIndexingTimer(indexingTimer, changesetIds.size());
            if (!timer.isTimeExpired()) continue;
            return startBatchIndex == 1L ? -1L : startBatchIndex;
        }
        return -1L;
    }

    private void upgradeContentIndex() throws DbException {
        if (this.repositoryConfig.isContentIndexingEnabled()) {
            long start = System.currentTimeMillis();
            Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] Upgrading content index."));
            LinkedList<Path> stillToProcess = new LinkedList<Path>();
            stillToProcess.add(Path.ROOT);
            int numFiles = 0;
            while (!stillToProcess.isEmpty()) {
                Path[] files;
                Path dir = (Path)stillToProcess.removeFirst();
                stillToProcess.addAll(Arrays.asList(this.rep.listDirs(dir)));
                for (Path file : files = this.rep.listFiles(dir)) {
                    try {
                        RcsFileHistoryFactory.Result history = this.rep.getFileHistory(file);
                        String head = history.getHistory().getHead();
                        if (head == null) continue;
                        RcsRevisionInfo headRev = history.getHistory().getRevision(head);
                        FileHistory fileHistory = ((CvsCache)this.cache).getFileHistory(history.getHistory().getPath());
                        if (fileHistory == null) continue;
                        int revid = fileHistory.getRevision(headRev.getRevision()).getRevID();
                        headRev.setRevID(revid);
                        if (history.getHistory().getRevisions().isEmpty()) {
                            Logs.APP_LOG.info((Object)("NOTE: skipping file with no revisions: " + file));
                            continue;
                        }
                        boolean didIndex = ((CvsCache)this.cache).getIndex().indexContents(history);
                        if (!didIndex) continue;
                        ++numFiles;
                    }
                    catch (IOException e2) {
                        Logs.APP_LOG.info((Object)("could not parse " + file + " , skipping from content index."), (Throwable)e2);
                    }
                    catch (RCSParser.ParseException e3) {
                        Logs.APP_LOG.info((Object)("could not parse " + file + " , skipping from content index."), (Throwable)e3);
                    }
                }
            }
            Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] Upgraded content index (" + numFiles + " files) in " + (System.currentTimeMillis() - start) / 1000L + "ms"));
        }
    }

    @Override
    public boolean isLicenseLimitReached() {
        return this.licenseLimitReached;
    }

    @Override
    public long reindexChangesets(Long startChangeset, EggTimer eggTimer) throws DbException {
        return this.recreateChangesetIndex(startChangeset, eggTimer);
    }
}

