/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.config.IndexingConfig;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.cvsrep.ChangeTree;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.cvsrep.cache.DiffTextIndexer;
import com.cenqua.fisheye.cvsrep.cache.PartialCvsCSID;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexWriter;

public class CvsRepositoryIndex {
    private final LuceneConnection<LuceneIndexes> mIndex;
    private final ChangesetIndexer changesetIndexer = new ChangesetIndexer();
    private final CommonIndexer indexer;
    private final LogicalPathMatcher logicalPathMatcher;
    private final String repositoryName;
    private final RepositoryStatus status;
    private final IndexingConfig indexingConfig;
    private final IndexingContext indexingContext;

    public CvsRepositoryIndex(LuceneConnection<LuceneIndexes> index0, IndexingConfig indexingConfig, CommonIndexer indexer, LogicalPathMatcher logicalPathMatcher, String repositoryName, RepositoryStatus status, IndexingContext indexingContext) {
        this.mIndex = index0;
        this.indexingConfig = indexingConfig;
        this.indexer = indexer;
        this.logicalPathMatcher = logicalPathMatcher;
        this.repositoryName = repositoryName;
        this.status = status;
        this.indexingContext = indexingContext;
    }

    public void indexFiles(List<RcsFileHistoryFactory.Result> histories) throws DbException {
        for (RcsFileHistoryFactory.Result history : histories) {
            this.indexContentsAndDiffText(history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexContentsAndDiffText(final RcsFileHistoryFactory.Result history) throws DbException {
        block7: {
            final RcsRevisionInfo headRev = history.getHistory().getRevision(history.getHistory().getHead());
            if (!headRev.isNewlyAdded()) {
                return;
            }
            try {
                history.getTree().initFileStream();
                if (!this.indexingConfig.isContentIndexingEnabled()) break block7;
                this.mIndex.withWriter(LuceneIndexes.CONTENT, new LuceneConnection.WriterAction<Void>(){

                    @Override
                    public Void perform(IndexWriter writer) throws IOException, DbException {
                        Path path = history.getHistory().getPath();
                        Set<Path> paths = Collections.singleton(path);
                        Logs.APP_LOG.debug((Object)("deleting old documents for path " + path));
                        CvsRepositoryIndex.this.indexer.deleteDocumentsForPaths(writer, paths);
                        if (CvsRepositoryIndex.this.shouldIndex(headRev)) {
                            Logs.APP_LOG.debug((Object)("indexing content " + headRev.getRevInfoKey()));
                            CvsRepositoryIndex.this.indexContents(writer, headRev, history.getTree());
                        }
                        return null;
                    }
                });
                DiffTextIndexer diffIndexer = new DiffTextIndexer(history);
                try {
                    diffIndexer.openReaders();
                    diffIndexer.indexDiffText(this.mIndex);
                }
                finally {
                    diffIndexer.closeReaders();
                }
            }
            finally {
                history.getTree().closeFileStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexContents(IndexWriter writer, RcsRevisionInfo info, ChangeTree tree) {
        Reader in;
        block4: {
            in = tree.getHeadTextReader();
            try {
                if (in == null) break block4;
                this.indexer.indexContents(writer, info.getRevID(), info, in, info.getRevision());
            }
            catch (Exception e2) {
                try {
                    Logs.APP_LOG.warn((Object)("could not index contents of " + info.getPath() + " " + info.getRevision() + ". Revision contents not indexed"), (Throwable)e2);
                }
                catch (Throwable throwable) {
                    IOHelper.close(in);
                    throw throwable;
                }
                IOHelper.close(in);
            }
        }
        IOHelper.close(in);
    }

    public boolean indexContents(final RcsFileHistoryFactory.Result history) throws DbException {
        final RcsRevisionInfo headRev = history.getHistory().getRevision(history.getHistory().getHead());
        if (this.shouldIndex(headRev)) {
            try {
                history.getTree().initFileStream();
                this.mIndex.withWriter(LuceneIndexes.CONTENT, new LuceneConnection.WriterAction<Void>(){

                    @Override
                    public Void perform(IndexWriter writer) throws IOException, DbException {
                        CvsRepositoryIndex.this.indexContents(writer, headRev, history.getTree());
                        return null;
                    }
                });
            }
            finally {
                history.getTree().closeFileStream();
            }
            return true;
        }
        return false;
    }

    public List<String> findSimilarPartialChangeSetIds(CvsCache cache, PartialCvsCSID partialId) throws DbException {
        RecentChangesParams2 params = new RecentChangesParams2();
        boolean isConstrained = false;
        WaybackSpec wb = new WaybackSpec();
        if (partialId.getBranch() != null) {
            wb.setBranch(partialId.getBranch());
            isConstrained = true;
        }
        if (partialId.getAuthor() != null) {
            wb.setAuthor(partialId.getAuthor());
            isConstrained = true;
        }
        if (isConstrained) {
            params.setWbFilter(wb);
        }
        long slop = 122880L;
        params.setMinDate(partialId.getDate() - 122880L);
        params.setMaxDate(partialId.getDate() + 122880L);
        return cache.findRecentChangeSetIds(params);
    }

    private boolean shouldIndex(RcsRevisionInfo headRev) {
        if (headRev.isDead() || headRev.isBinary() || headRev.getRevID() < 0) {
            return false;
        }
        return this.indexingConfig.isOfIndexableSize(headRev.getPath(), headRev.getFile().getHeadByteCount(), headRev.getRevision());
    }

    public void indexMetaData(Set<CvsCSID> changesetIds, CvsCache cache) throws DbException {
        Collection changeSets = Collections2.transform(changesetIds, (Function)new Function<CvsCSID, String>(){

            public String apply(CvsCSID from) {
                try {
                    return from.toString();
                }
                catch (DbException exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
        this.indexMetaData(changeSets, cache, false);
    }

    public void reindexMetaData(Iterable<String> csids, CvsCache cache, boolean isUpdate) throws DbException {
        this.indexMetaData(csids, cache, isUpdate);
    }

    private void indexMetaData(Iterable<String> csids, CvsCache cache, boolean isUpdate) throws DbException {
        boolean hasPre24Changesets = isUpdate && this.indexingContext.getCrossRepLuceneIndex().getRescanStatus(cache).needsPre24ChangesetHandling();
        this.changesetIndexer.indexChangesetsAndAuthors(cache.getCrossRepLuceneConnection(), cache, csids, this.status, isUpdate, null, hasPre24Changesets);
        this.indexingContext.getBranchCrossRepoIndexer().indexBranches(cache.getBranches(), cache, this.status);
        this.indexingContext.getPathCrossRepoIndexer().indexPathsForChangeSetIds(this.repositoryName, cache, csids, this.logicalPathMatcher, this.status);
    }
}

