/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class CvsHistoryReader {
    private File mFile;
    private InputStream mIn;

    public CvsHistoryReader(File file) throws IOException {
        this.mFile = file;
        this.open(-1L);
    }

    private void open(long state) throws IOException {
        if (this.mIn != null) {
            return;
        }
        this.mIn = new BufferedInputStream(new FileInputStream(this.mFile));
        if (state >= 0L) {
            this.mIn.skip(state);
        }
    }

    public void close() throws IOException {
        if (this.mIn == null) {
            return;
        }
        InputStream in = this.mIn;
        this.mIn = null;
        in.close();
    }

    public void restore(long state) throws IOException {
        this.close();
        this.open(state);
    }

    private int read() throws IOException {
        int c2 = this.mIn.read();
        return c2;
    }

    private String nextLine() throws IOException {
        int c2;
        while (CvsHistoryReader.isEOL(c2 = this.read())) {
        }
        if (c2 == -1) {
            return null;
        }
        StringBuffer line = new StringBuffer();
        while (c2 != -1 && !CvsHistoryReader.isEOL(c2)) {
            line.append((char)c2);
            c2 = this.read();
        }
        return line.toString();
    }

    public Record nextRecord() throws IOException {
        long date;
        char op;
        String[] fields;
        while (true) {
            String line;
            if ((line = this.nextLine()) == null) {
                return null;
            }
            fields = (line = line.trim()).split("\\|");
            if (fields.length < 6) {
                Logs.APP_LOG.warn((Object)("could not understand line in " + this.mFile + ": " + line));
                continue;
            }
            String f0 = fields[0];
            if (f0.length() < 2) {
                Logs.APP_LOG.warn((Object)("could not understand line in " + this.mFile + " first field : " + line));
                continue;
            }
            op = f0.charAt(0);
            try {
                date = Integer.parseInt(f0.substring(1), 16);
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.warn((Object)("could not understand date in " + this.mFile + " first field : " + line));
                continue;
            }
            break;
        }
        return new Record(op, date, fields);
    }

    private static boolean isEOL(int c2) {
        return c2 == 10 || c2 == 13;
    }

    public static long findStartOfLastLine(File file) throws IOException {
        if (!file.isFile()) {
            return 0L;
        }
        try (RandomAccessFile in = new RandomAccessFile(file, "r");){
            long off = in.length();
            boolean trailingEOL = true;
            while (true) {
                if (--off < 0L) {
                    long l2 = 0L;
                    return l2;
                }
                in.seek(off);
                int c2 = in.read();
                if (CvsHistoryReader.isEOL(c2)) {
                    if (trailingEOL) continue;
                    long l3 = off + 1L;
                    return l3;
                }
                trailingEOL = false;
            }
        }
    }

    public static class Record {
        public final char op;
        public final long date;
        public final String[] fields;

        public Record(char op, long date, String[] fields) {
            this.op = op;
            this.date = date;
            this.fields = fields;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.op).append(" ").append(this.date);
            for (String field : this.fields) {
                buf.append("|").append(field);
            }
            return buf.toString();
        }
    }
}

