/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.cache.CvsHistoryReader;
import com.cenqua.fisheye.cvsrep.cache.CvsScanner;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CvsHistoryChangeDetector {
    private static final int MAX_BATCH = 100;
    private final CvsScanner scanner;
    private final File mHistoryFile;
    private final long mFullScanPeriod;
    private final boolean mPeriodicFullScanEnabled;
    private final String mPrefix;
    private long mLastFullScan = 0L;
    private long mHistoryLastMod = -1L;
    private long mStartOfLastLine = 0L;
    private boolean mNeedsFullScan;
    private volatile boolean mFullscanRequested = false;
    private Set<String> mDirsTouched = new HashSet<String>();
    private boolean hasRunOnce = false;
    private RevisionCache.CacheListener cacheListener;

    public CvsHistoryChangeDetector(CvsScanner scanner, File historyFile, long fullScanPeriod, String stripPrefix) {
        this.scanner = scanner;
        this.mHistoryFile = historyFile;
        this.mFullScanPeriod = fullScanPeriod;
        this.mPeriodicFullScanEnabled = this.mFullScanPeriod != 0L;
        this.mPrefix = CvsHistoryChangeDetector.cleanDirString(stripPrefix);
    }

    public void setCacheListener(RevisionCache.CacheListener cacheListener) {
        this.cacheListener = cacheListener;
    }

    public void requestFullscan() {
        this.mFullscanRequested = true;
    }

    public void ping() {
        this.scanner.resetFoundChanges();
        if (!this.hasRunOnce) {
            this.doRunOnce();
        } else if (this.mFullscanRequested) {
            this.mFullscanRequested = false;
            this.doPeriodicScan();
        } else if (this.mPeriodicFullScanEnabled && this.mLastFullScan + this.mFullScanPeriod < System.currentTimeMillis()) {
            this.doPeriodicScan();
        } else {
            this.doScanHistoryFile();
        }
        if (this.scanner.foundChanges() && this.cacheListener != null) {
            this.cacheListener.cacheUpdated();
        }
    }

    private void doScanHistoryFile() {
        try {
            long hlm = this.mHistoryFile.lastModified();
            if (this.mHistoryFile.isFile() && hlm != this.mHistoryLastMod) {
                Logs.APP_LOG.debug((Object)("history file modified " + this.mHistoryFile));
                long startOfLastLine = CvsHistoryReader.findStartOfLastLine(this.mHistoryFile);
                this.scanHistoryFile();
                this.mHistoryLastMod = hlm;
                this.mStartOfLastLine = startOfLastLine;
                this.scanner.setLicensePolicyReached(false, null);
            }
        }
        catch (LicensePolicyException e2) {
            this.scanner.setLicensePolicyReached(true, e2);
        }
        catch (Exception e3) {
            Logs.APP_LOG.error((Object)("problem scanning history file " + this.mHistoryFile), (Throwable)e3);
        }
    }

    private void doPeriodicScan() {
        try {
            Logs.APP_LOG.info((Object)"periodic full scan");
            long startTime = System.currentTimeMillis();
            this.scanner.fullSlurp(startTime);
            this.mLastFullScan = System.currentTimeMillis();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"problem with periodic scan", (Throwable)e2);
        }
    }

    private void doRunOnce() {
        try {
            Logs.APP_LOG.debug((Object)("starting CVS history file updater on " + this.mHistoryFile.getAbsolutePath() + ", " + (this.mPeriodicFullScanEnabled ? "fullscan every " + this.mFullScanPeriod + "ms" : "periodic fullscan disabled")));
            if (this.mHistoryFile.isFile()) {
                if (!this.mHistoryFile.canRead()) {
                    Logs.APP_LOG.warn((Object)("I don't have read access to " + this.mHistoryFile.getAbsolutePath()));
                }
            } else {
                Logs.APP_LOG.warn((Object)("no such file " + this.mHistoryFile.getAbsolutePath()));
            }
            Logs.APP_LOG.info((Object)"initial full scan");
            this.mStartOfLastLine = CvsHistoryReader.findStartOfLastLine(this.mHistoryFile);
            long startTime = System.currentTimeMillis();
            this.scanner.fullSlurp(startTime);
            this.mLastFullScan = System.currentTimeMillis();
            this.hasRunOnce = true;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"problem with initial scan", (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanHistoryFile() throws IOException, DbException, LicensePolicyException {
        long t0 = System.currentTimeMillis();
        Logs.APP_LOG.debug((Object)("starting scan of history file at offset " + this.mStartOfLastLine + " at starttime " + t0));
        this.mNeedsFullScan = false;
        this.mDirsTouched.clear();
        try (CvsHistoryReader hreader = new CvsHistoryReader(this.mHistoryFile);){
            CvsHistoryReader.Record rec;
            hreader.restore(this.mStartOfLastLine);
            while ((rec = hreader.nextRecord()) != null) {
                switch (rec.op) {
                    case 'T': {
                        String module = rec.fields[5];
                        this.foundRemoteTag(module);
                        break;
                    }
                    case 'A': 
                    case 'M': 
                    case 'R': {
                        String dir = rec.fields[3];
                        String file = rec.fields[5];
                        this.foundModifiedFile(dir, file);
                        break;
                    }
                }
            }
        }
        this.scanDirs();
        long startTime = System.currentTimeMillis();
        if (this.mNeedsFullScan && this.mPeriodicFullScanEnabled) {
            Logs.APP_LOG.info((Object)"full scan");
            this.scanner.fullSlurp(startTime);
        } else {
            if (this.mNeedsFullScan) {
                Logs.APP_LOG.debug((Object)"remote tag found - needs full scan, but periodic full scan is disabled");
            }
            this.scanner.scanForChangesets(startTime);
        }
    }

    private void foundModifiedFile(String dir, String file) throws DbException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)("history: modified " + dir + " " + file));
        if (this.mPrefix != null && (dir = CvsHistoryChangeDetector.cleanDirString(dir)).startsWith(this.mPrefix)) {
            dir = dir.substring(this.mPrefix.length());
            dir = CvsHistoryChangeDetector.cleanDirString(dir);
            Logs.APP_LOG.debug((Object)("history: prefix stripped to " + dir));
        }
        this.mDirsTouched.add(dir);
        if (this.mDirsTouched.size() >= 100) {
            this.scanDirs();
        }
    }

    private void scanDirs() throws DbException, LicensePolicyException {
        if (this.mDirsTouched.isEmpty()) {
            return;
        }
        for (String dir : this.mDirsTouched) {
            this.scanner.scanDir(new Path(dir));
        }
        this.mDirsTouched.clear();
    }

    private void foundRemoteTag(String module) {
        Logs.APP_LOG.debug((Object)("history: tag " + module));
        this.mNeedsFullScan = true;
    }

    private static String cleanDirString(String stripPrefix) {
        if (stripPrefix != null) {
            if (stripPrefix.startsWith("/")) {
                stripPrefix = stripPrefix.substring(1);
            }
            if (stripPrefix.endsWith("/")) {
                stripPrefix = stripPrefix.substring(0, stripPrefix.length() - 1);
            }
        }
        return stripPrefix;
    }
}

