/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.util.MinMaxLongRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CvsFileHistory
implements FileHistory {
    private final boolean binary;
    private final KeywordExpansion expand;
    private final Path path;
    private final String head;
    private final String mainBranch;
    private final Map<String, CommonFileRevision> revisions;

    public CvsFileHistory(boolean binary, String expand, Path path, String head, String mainBranch, Map<String, CommonFileRevision> revisions) {
        this.binary = binary;
        this.expand = expand == null ? null : KeywordExpansion.parse(expand);
        this.path = path;
        this.head = head;
        this.mainBranch = mainBranch;
        this.revisions = revisions;
    }

    @Override
    public boolean isBinary() {
        return this.binary;
    }

    public KeywordExpansion getExpand() {
        return this.expand;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getHead() {
        return this.head;
    }

    @Override
    public String getMainBranch() {
        return this.mainBranch;
    }

    @Override
    public Collection<FileRevision> getRevisions() {
        return new ArrayList<FileRevision>(this.revisions.values());
    }

    @Override
    public FileRevision getRevision(String rev) {
        return this.revisions.get(rev);
    }

    @Override
    public List<FileRevision> getRevisionsForRev(String rev) {
        return Collections.singletonList(this.getRevision(rev));
    }

    @Override
    public List<FileRevision> getRevisionsSorted() {
        ArrayList<FileRevision> result = new ArrayList<FileRevision>(this.revisions.values());
        Collections.sort(result, new Comparator<FileRevision>(){

            @Override
            public int compare(FileRevision o1, FileRevision o2) {
                CvsRevInfo a2 = (CvsRevInfo)o1;
                CvsRevInfo b2 = (CvsRevInfo)o2;
                return b2.getCvsRevision().compareTo(a2.getCvsRevision());
            }
        });
        return result;
    }

    @Override
    public String resolveRevisionFromString(Path lpath, String sym) {
        if (this.revisions.containsKey(sym)) {
            return sym;
        }
        IndexableFileRevision br = null;
        for (FileRevision info : this.getRevisions()) {
            if (info.getTags().contains(sym)) {
                return info.getRevision();
            }
            if (!info.getBranch().equals(sym)) continue;
            if (br == null) {
                br = info;
                continue;
            }
            if (info.getDate() <= br.getDate()) continue;
            br = info;
        }
        if (br != null) {
            return br.getRevision();
        }
        if ("HEAD".equals(sym)) {
            return this.getHead();
        }
        return null;
    }

    @Override
    public MinMaxLongRange getDateRange() {
        MinMaxLongRange range = new MinMaxLongRange();
        for (FileRevision info : this.getRevisions()) {
            range.add(info.getDate());
        }
        return range;
    }

    @Override
    public List<String> getRevisions(String br) {
        TreeMap<FileRevision, String> result = new TreeMap<FileRevision, String>(FileRevision.OLDEST_FIRST_COMPARATOR);
        for (FileRevision info : this.getRevisions()) {
            if (!info.getBranch().equals(br)) continue;
            result.put(info, info.getRevision());
        }
        return new ArrayList<String>(result.values());
    }

    @Override
    public List<FileRevision> getNonBranchRevisions() {
        return Collections.emptyList();
    }

    @Override
    public String getBranchPoint(String branch) {
        for (FileRevision info : this.getRevisions()) {
            if (!info.getBranchPoints().contains(branch)) continue;
            return info.getRevision();
        }
        return null;
    }

    @Override
    public Collection<String> getBranches() {
        HashSet<String> result = new HashSet<String>();
        for (FileRevision info : this.getRevisions()) {
            result.add(info.getBranch());
            result.addAll(info.getBranchPoints());
        }
        return result;
    }

    @Override
    public String getFirstRevisionOnBranch(String branch) {
        List<String> revs = this.getRevisions(branch);
        if (revs.size() > 0) {
            return revs.get(0);
        }
        return null;
    }

    @Override
    public boolean containsRevision(String revision) {
        return this.revisions.containsKey(revision);
    }
}

