/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.impl.ChangeSetAncestryProcessor;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class CvsChangeSetAncestryProcessor
extends ChangeSetAncestryProcessor {
    private final InternalRevisionCache<?> revCache;

    public CvsChangeSetAncestryProcessor(CvsCache revCache) {
        super(revCache.getChangeSetDAO());
        this.revCache = revCache;
    }

    @Override
    public boolean process(final MutableChangeSet changeset) throws DbException {
        boolean changed = false;
        HashSet<String> parentIds = new HashSet<String>();
        for (String branch : changeset.getBranches()) {
            Object latestChange;
            Object parent = this.csDAO.getLatestChangesetOnBranchUpTo(branch, changeset.getId(), false);
            if (parent == null && (latestChange = this.csDAO.getLatestChangesetOnBranch(branch)) != null && !changeset.getId().equals(latestChange.getId()) && latestChange.getDate() <= changeset.getDate()) {
                parent = latestChange;
            }
            if (parent == null) continue;
            parentIds.add(parent.getId());
        }
        if (!parentIds.isEmpty() && !parentIds.equals(new HashSet<String>(changeset.getParents()))) {
            changeset.setParents(new ArrayList<String>(parentIds));
            changed = true;
        }
        final String branch = changeset.getBranch();
        if (changeset.getParents().isEmpty()) {
            final HashMap branchAncestorMap = new HashMap();
            final FileRevisionDAO dao = this.revCache.getFileRevisionDAO();
            this.revCache.visitRevisionsAtBranchPoint(changeset.getBranch(), new Visitor<FileRevision>(){

                @Override
                public void visit(FileRevision fr) {
                    AncestorLink ancestorlink = dao.getCommonRevInfoDAO().getAncestorOf(fr.getRevID());
                    boolean isDead = dao.getCommonRevInfoDAO().isDeleted(fr.getRevID());
                    if (ancestorlink == null && isDead) {
                        return;
                    }
                    long date = dao.getCommonRevInfoDAO().getDate(fr.getRevID());
                    if (!(date > changeset.getDate() || branchAncestorMap.containsKey(branch) && (Long)((Pair)branchAncestorMap.get(branch)).getFirst() >= date)) {
                        branchAncestorMap.put(branch, Pair.newInstance(date, fr));
                    }
                }
            });
            if (!branchAncestorMap.isEmpty()) {
                HashSet<String> parentIds2 = new HashSet<String>();
                for (Pair ancestor : branchAncestorMap.values()) {
                    parentIds2.add(((FileRevision)ancestor.getSecond()).getChangeSetId());
                }
                HashSet<String> currentParents = new HashSet<String>(changeset.getParents());
                if (currentParents.addAll(parentIds2)) {
                    changeset.setParents(new ArrayList<String>(currentParents));
                    changed = true;
                }
            }
        }
        return changed;
    }
}

