/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.DbUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.config.IndexingConfig;
import com.cenqua.fisheye.cvsrep.Annotator;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSet;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSetAncestryProcessor;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSetDAO;
import com.cenqua.fisheye.cvsrep.cache.CvsRepositoryIndex;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.PartialCvsCSID;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CvsCache
extends BaseRevisionCache<CvsRevInfo, CvsChangeSet, CommonStringTables> {
    private final RevisionInfoCache revisionInfoCache;
    private final CvsRepositoryIndex mIndex;
    private final CvsRepository repository;
    private final CvsChangeSetDAO csDAO;
    private final CvsChangeSetAncestryProcessor ancestryProcessor;

    public CvsCache(long cacheSerial, int version, RevisionInfoCache db, LuceneConnection<LuceneIndexes> index0, CvsRepository repository, IndexingConfig cfg, CommonIndexer indexer, LicenseEnforcer licenseEnforcer, LogicalPathMatcher logicalPathMatcher, IndexingContext indexingContext, RepositoryStatus status) {
        super(cfg.getStatus(), cacheSerial, version, db.getInfDb(), index0, db.getCommonStringTables(), licenseEnforcer, indexingContext);
        this.revisionInfoCache = db;
        this.repository = repository;
        this.mIndex = new CvsRepositoryIndex(index0, cfg, indexer, logicalPathMatcher, this.repository.getName(), status, indexingContext);
        this.csDAO = new CvsChangeSetDAO(cfg.getStatus(), db.getInfDb(), (CommonStringTables)this.getStringTables(), this.revisionInfoCache, licenseEnforcer);
        this.ancestryProcessor = new CvsChangeSetAncestryProcessor(this);
        db.setBranchDAO(this.getBranchDAO());
    }

    public CvsRepositoryIndex getIndex() {
        return this.mIndex;
    }

    public CvsRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public String getDefaultBranch() {
        return "MAIN";
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        return this.revisionInfoCache.listFiles(dir);
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        return this.revisionInfoCache.listDirs(dir);
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        return this.revisionInfoCache.isFile(path);
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        return path.isRoot() || this.revisionInfoCache.isDir(path);
    }

    public FileRevision getRevisionInfo(RevInfoKey key) throws DbException {
        return this.revisionInfoCache.findRevInfo(key);
    }

    public FileRevision getRevisionInfo(int revid) throws DbException {
        return this.revisionInfoCache.findRevInfo(revid);
    }

    public RevisionInfoCache getRevisionInfoCache() {
        return this.revisionInfoCache;
    }

    @Override
    public FileRevision getFileRevision(int revid) throws DbException {
        return this.getRevisionInfo(revid);
    }

    @Override
    public FileRevision getFileRevision(RevInfoKey rkey) throws DbException {
        return this.getRevisionInfo(rkey);
    }

    @Override
    public FileRevision getFileRevision(int revid, boolean lazy) throws DbException {
        return lazy ? this.revisionInfoCache.loadLazy(revid) : this.revisionInfoCache.load(revid);
    }

    @Override
    public FileHistory getFileHistory(Path lpath, boolean physicalOnly) throws DbException {
        return this.revisionInfoCache.findFileHistory(lpath);
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        return this.getFileHistory(path);
    }

    @Override
    public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> patchRevisions) throws DbException {
        HashMap<Path, String> revisions = new HashMap<Path, String>();
        for (Map.Entry<Path, RevisionIdentifier> entry : patchRevisions.entrySet()) {
            revisions.put(entry.getKey(), entry.getValue().getId());
        }
        return revisions;
    }

    @Override
    public Blame getBlameFallback(RevInfoKey rk) throws DbException {
        RcsFileHistoryFactory.Result hr;
        try {
            hr = this.repository.getFileHistory(rk.getPath());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        catch (RCSParser.ParseException e3) {
            throw new DbException(e3);
        }
        FileHistory hist = this.getFileHistory(rk.getPath());
        Annotator ann = new Annotator(hist, hr.getTree());
        ann.annotate(new Revision(rk.getRev()));
        return new Blame(ann.getChunks());
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.CVS;
    }

    @Override
    public CvsChangeSet getChangeSet(String csid) throws DbException {
        return (CvsChangeSet)this.csDAO.load(csid);
    }

    @Override
    public String getChangeSetId(int revid) throws DbException {
        CvsCSID id = this.revisionInfoCache.getChangeSetId(revid);
        return id == null ? null : id.toString();
    }

    @Override
    public long getLastModifiedDate() throws DbException {
        return this.revisionInfoCache.getLastModified();
    }

    @Override
    public void touchLastModifiedDate() throws DbException {
        this.revisionInfoCache.touch();
    }

    public ChangeSet getChangeSet(CvsCSID csid) throws DbException {
        if (csid != null) {
            return this.getChangeSet(csid.toString());
        }
        return null;
    }

    @Override
    public String getImpliedBranch(Path path) {
        return null;
    }

    @Override
    public List<String> getSimilarChangeSetIds(String csid) throws DbException {
        CvsCSID id = CvsCSID.parse(csid);
        if (id != null) {
            return this.revisionInfoCache.getSimilarChangeSetIds(id);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialIdStr) throws DbException {
        PartialCvsCSID partialId = PartialCvsCSID.parse(partialIdStr);
        if (partialId != null) {
            return this.mIndex.findSimilarPartialChangeSetIds(this, partialId);
        }
        return Collections.emptyList();
    }

    @Override
    public Charset getTextEncoding(RevInfoKey key) {
        return this.repository.getCharset();
    }

    @Override
    public void getTextRevision(RevInfoKey key, OutputStream aOut, String kopt, String symrev) throws IOException, DbException {
        try {
            CvsRevInfo info = this.revisionInfoCache.findRevInfo(key);
            if (info == null) {
                throw new DbException("revision not found: " + key);
            }
            KeywordExpansion k2 = kopt == null ? null : KeywordExpansion.parse(kopt);
            KeywordExpansion.KeywordExpansionInfo ki = info.makeKeywordExpansionInfo(symrev);
            this.repository.getTextRevision(info.getPath(), info.getCvsRevision(), ki, aOut, k2);
        }
        catch (RCSParser.ParseException e2) {
            Logs.APP_LOG.warn((Object)"problem getting text revision", (Throwable)e2);
            throw new IOException(e2.getMessage());
        }
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, OutputStream aOut) throws IOException, DbException {
        try {
            CvsRevInfo info = this.revisionInfoCache.findRevInfo(key);
            if (info == null) {
                throw new DbException("revision not found: " + key);
            }
            this.repository.getBinaryRevision(info.getPath(), info.getCvsRevision(), aOut);
        }
        catch (RCSParser.ParseException e2) {
            Logs.APP_LOG.warn((Object)"problem getting binary revision", (Throwable)e2);
            throw new IOException(e2.getMessage());
        }
    }

    public File getFilesystemFileForPath(Path path) throws FileNotFoundException {
        return this.repository.getFilesystemFileForPath(path);
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.revisionInfoCache.getCommonRevInfoDAO();
    }

    public CvsChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    public Set<Tag> getAllTags() throws DbException {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (String tag : DbUtil.getStringKeysFromLongToLong(this.getInfDb(), CommonSchema.E_TAG_TO_REVID, ((CommonStringTables)this.getStringTables()).tagDB)) {
            tags.add(new Tag(tag, null));
        }
        return tags;
    }

    @Override
    public RevisionInfoCache getFileRevisionDAO() {
        return this.revisionInfoCache;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.revisionInfoCache.isCaseSensitive();
    }

    @Override
    public boolean isAuthorLocEnabled() {
        return true;
    }

    @Override
    public boolean isLocEnabled() {
        return true;
    }

    @Override
    public boolean isStoreDiffs() {
        return true;
    }

    @Override
    public FileRevision getLatestFileRevision(Path path) throws DbException {
        String head = this.revisionInfoCache.getHeadRevision(path);
        if (head == null) {
            return null;
        }
        int revId = this.getCommonRevInfoDAO().getRevId(new RevInfoKey(path, head));
        return this.getFileRevision(revId, true);
    }

    public void updateChangesetAncestry(CvsCSID csid) {
        CvsChangeSet changeset = (CvsChangeSet)this.csDAO.load(csid.toString());
        if (this.ancestryProcessor.process(changeset)) {
            try {
                this.csDAO.store(changeset);
            }
            catch (LicensePolicyException e2) {
                throw new DbException(e2);
            }
        }
    }

    public void addBranchPointBranches(CvsCSID csid) {
        final CvsChangeSet changeset = (CvsChangeSet)this.csDAO.load(csid.toString());
        changeset.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision rev) {
                for (String branch : rev.getBranchPoints()) {
                    if (CvsCache.this.getBranchDAO().exists(branch)) continue;
                    Branch bpBranch = new Branch(branch, changeset.getId(), BranchState.INACTIVE);
                    CvsCache.this.getBranchDAO().store(bpBranch, true);
                }
            }
        });
    }
}

