/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CvsCSID
implements Serializable,
Comparable {
    private static final Pattern PARSE_PROG = Pattern.compile("^([^:]+):([^:]+):(\\d\\d\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(\\d\\d)(:(\\d+))?$");
    private final String mBranch;
    private final String mAuthor;
    private final long mDate;
    private final int mUniqueCount;

    public CvsCSID(String branch, String author, long date, int uc) {
        this.mBranch = branch;
        this.mAuthor = author;
        this.mDate = date;
        this.mUniqueCount = uc;
    }

    public String getBranch() {
        return this.mBranch;
    }

    public int getUniqueID() {
        return this.mUniqueCount;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public long getDate() {
        return this.mDate;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mBranch).append(':').append(this.mAuthor).append(':');
        int[] time = DateHelper.timeToComponents(this.mDate);
        StringUtil.pad(buf, time[0], 4);
        StringUtil.pad(buf, time[1], 2);
        StringUtil.pad(buf, time[2], 2);
        StringUtil.pad(buf, time[3], 2);
        StringUtil.pad(buf, time[4], 2);
        StringUtil.pad(buf, time[5], 2);
        if (this.mUniqueCount != 0) {
            buf.append(':').append(this.mUniqueCount);
        }
        return buf.toString();
    }

    public int compareTo(Object o2) {
        if (!(o2 instanceof CvsCSID)) {
            return -1;
        }
        CvsCSID rhs = (CvsCSID)o2;
        int cmp = CompareUtil.compareTo(this.mDate, rhs.mDate);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.mBranch.compareTo(rhs.mBranch);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.mAuthor.compareTo(rhs.mAuthor);
        if (cmp != 0) {
            return cmp;
        }
        cmp = CompareUtil.compareTo(this.mUniqueCount, rhs.mUniqueCount);
        return cmp;
    }

    public boolean equals(Object o2) {
        return this.compareTo(o2) == 0;
    }

    public int hashCode() {
        int result = this.mBranch.hashCode();
        result = 29 * result + this.mAuthor.hashCode();
        result = 29 * result + (int)(this.mDate ^ this.mDate >>> 32);
        result = 29 * result + this.mUniqueCount;
        return result;
    }

    public static CvsCSID parse(String str) {
        if (str == null) {
            return null;
        }
        Matcher m2 = PARSE_PROG.matcher(str);
        if (m2.matches()) {
            String br = m2.group(1);
            String auth = m2.group(2);
            int[] time = new int[]{Integer.parseInt(m2.group(3)), Integer.parseInt(m2.group(4)), Integer.parseInt(m2.group(5)), Integer.parseInt(m2.group(6)), Integer.parseInt(m2.group(7)), Integer.parseInt(m2.group(8))};
            long date = DateHelper.componentsToTime(time);
            String ucStr = m2.group(10);
            int uc = ucStr == null ? 0 : Integer.parseInt(m2.group(10));
            return new CvsCSID(br, auth, date, uc);
        }
        return null;
    }
}

