/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.cvsrep.cache.CvsDirInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsRepositoryIndex;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class CachedDirUpdater {
    private final Path mDir;
    private final CvsRepository mRep;
    private final RevisionInfoCache mDB;
    private final CvsRepositoryIndex mIndex;
    private final CvsDirInfo mInfo;
    private final boolean mIsNewInfo;
    private final RepositoryStatus status;

    public CachedDirUpdater(Path dir, CvsRepository repository, CvsCache cache, RepositoryStatus status) throws DbException {
        this.mDir = dir;
        this.mRep = repository;
        this.mDB = cache.getRevisionInfoCache();
        this.status = status;
        this.mIndex = cache.getIndex();
        CvsDirInfo info = this.mDB.findCvsDirInfo(this.mDir);
        boolean isNewInfo = false;
        if (info == null) {
            info = new CvsDirInfo(this.mDir);
            isNewInfo = true;
        }
        this.mInfo = info;
        this.mIsNewInfo = isNewInfo;
    }

    boolean scanPhase1() throws DbException, LicensePolicyException {
        boolean wasUpdated = this.recomputeDirInfo(this.mIsNewInfo);
        if (wasUpdated) {
            this.flush();
        }
        return wasUpdated || this.mIsNewInfo;
    }

    private boolean recomputeDirInfo(boolean isNewInfo) throws DbException, LicensePolicyException {
        boolean changed;
        Path[] realFiles = this.mRep.listFiles(this.mDir);
        long[] timestamps = new long[realFiles.length];
        long youngest = 0L;
        for (int i2 = 0; i2 < realFiles.length; ++i2) {
            Path realPath = realFiles[i2];
            try {
                File realFile = this.mRep.getFilesystemFileForPath(realPath);
                long ts = realFile.lastModified();
                if (ts > youngest) {
                    youngest = ts;
                }
                timestamps[i2] = ts;
                continue;
            }
            catch (FileNotFoundException realFile) {
                // empty catch block
            }
        }
        long previousYoungest = this.mInfo.getYoungestTimestamp();
        boolean bl = changed = this.mInfo.getFileCount() != realFiles.length || previousYoungest != youngest;
        if (changed || isNewInfo) {
            Logs.APP_LOG.debug((Object)("updating " + this.mDir));
            this.mInfo.setFileCount(realFiles.length);
            this.mInfo.setYoungestTimestamp(youngest);
            BatchingIndexer indexer = new BatchingIndexer();
            for (int i3 = 0; i3 < realFiles.length; ++i3) {
                if (this.status.isStopRequested()) {
                    Logs.APP_LOG.info((Object)"stop requested");
                    return false;
                }
                Path realPath = realFiles[i3];
                long ts = timestamps[i3];
                if (ts <= previousYoungest) continue;
                if (Logs.APP_LOG.isDebugEnabled()) {
                    long tot = Runtime.getRuntime().totalMemory();
                    long free = Runtime.getRuntime().freeMemory();
                    Logs.APP_LOG.debug((Object)(" changed, parsing " + realPath + " (free=" + (tot == 0L ? -1L : free * 100L / tot) + "%, " + free + "/" + tot + ")"));
                }
                try {
                    RcsFileHistoryFactory.Result history = this.mRep.getFileHistory(realPath);
                    if (history.getHistory().getRevisions().isEmpty()) {
                        Logs.APP_LOG.info((Object)("NOTE: skipping file with no revisions: " + realPath));
                        continue;
                    }
                    indexer.addToIndex(history);
                    continue;
                }
                catch (IOException e2) {
                    Logs.APP_LOG.error((Object)("could not parse " + realPath + " , skipping"), (Throwable)e2);
                    continue;
                }
                catch (RCSParser.ParseException e3) {
                    Logs.APP_LOG.error((Object)("could not parse " + realPath + " , skipping"), (Throwable)e3);
                }
            }
            indexer.batchFlush();
            this.mDB.putDirInfo(this.mInfo);
            this.flush();
        }
        return changed;
    }

    private void flush() throws DbException {
        this.mDB.commit();
    }

    private class BatchingIndexer {
        public static final int BATCH_SIZE = 200;
        private final List<RcsFileHistoryFactory.Result> mToIndex = new ArrayList<RcsFileHistoryFactory.Result>(200);
        private int mSize = 0;

        private BatchingIndexer() {
        }

        public void addToIndex(RcsFileHistoryFactory.Result hist) throws DbException, LicensePolicyException {
            this.mToIndex.add(hist);
            this.mSize += hist.getHistory().getRevisions().size();
            if (this.mSize >= 200) {
                this.batchFlush();
            } else {
                long tot = Runtime.getRuntime().totalMemory();
                long free = Runtime.getRuntime().freeMemory();
                int thresh = 10;
                if (free == 0L || tot / free >= 10L) {
                    Logs.APP_LOG.debug((Object)"batching now, to free more memory");
                    this.batchFlush();
                }
            }
        }

        public void batchFlush() throws DbException, LicensePolicyException {
            if (!this.mToIndex.isEmpty()) {
                Logs.APP_LOG.debug((Object)("batching " + this.mToIndex.size() + " files (" + this.mSize + " revs)"));
                CachedDirUpdater.this.mDB.index(this.mToIndex);
                CachedDirUpdater.this.mIndex.indexFiles(this.mToIndex);
                this.mToIndex.clear();
                this.mSize = 0;
            }
            CachedDirUpdater.this.flush();
        }
    }
}

