/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class CachedChangesetUpdater {
    public static final int CHANGESET_DATE_THRESHOLD = 600000;
    private static final int BATCH_SIZE = 100;
    private final InfDbRevisionInfoCache mDB;
    private final RepositoryStatus mStatus;
    private final SimpleDateFormat mStatusDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private final InfinityDbHandle dbh;
    private boolean foundChanges = false;

    public CachedChangesetUpdater(RepositoryStatus st, InfinityDbHandle dbh, InfDbRevisionInfoCache db) {
        this.mDB = db;
        this.dbh = dbh;
        this.mStatus = st;
    }

    public boolean foundChanges() {
        return this.foundChanges;
    }

    public void processSomeChangesets(long noLaterThan, Set<CvsCSID> changesets) throws DbException {
        this.foundChanges = false;
        this.process(noLaterThan, changesets);
    }

    private void process(long noLaterThan, Set<CvsCSID> changesets) throws DbException {
        long date;
        Logs.APP_LOG.debug((Object)"Scanning for changesets");
        NextDateIterator dateIterator = new NextDateIterator(this.dbh.get());
        int numProcessed = 0;
        while (dateIterator.hasNextDate() && !this.mStatus.isStopRequested() && numProcessed <= 100 && (date = dateIterator.nextDate()) < noLaterThan) {
            this.mStatus.setMessage("scanning for changesets from " + this.mStatusDateFormat.format(new Date(date)));
            IntArrayList revIds = dateIterator.nextRevids();
            ArrayList<CvsRevInfo> revs = new ArrayList<CvsRevInfo>(revIds.size());
            for (int i2 = 0; i2 < revIds.size(); ++i2) {
                int revid = revIds.getInt(i2);
                CvsRevInfo ri = this.mDB.findRevInfo(revid);
                if (ri == null) {
                    Logs.APP_LOG.error((Object)("BUG: unable to insert revision into a changeset: revid=" + revid));
                    continue;
                }
                revs.add(ri);
            }
            Collections.sort(revs, RevInfoPathComparator.INSTANCE);
            for (CvsRevInfo ri : revs) {
                changesets.add(this.assignToChangeset(ri));
                this.foundChanges = true;
                ++numProcessed;
            }
        }
    }

    private CvsCSID assignToChangeset(CvsRevInfo ri) throws DbException {
        try {
            long minDate = ri.getDate() - 600000L;
            long maxDate = ri.getDate();
            AndQuery3 q2 = new AndQuery3();
            q2.addClause(new TermQuery3(RevInfoEAV.E_ISCSMARKER_TO_REVID, true, RevInfoEAV.A_REVID));
            long cmtid = this.mDB.getCommentId(ri.getComment());
            q2.addClause(new TermQuery3(CommonSchema.E_COMMENT_ID_TO_REVID, cmtid, null));
            q2.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, ri.getBranch(), null));
            String author = ri.getAuthor();
            if (author == null) {
                author = "";
            }
            q2.addClause(new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, author.toLowerCase(Locale.US), null));
            q2.addClause(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, minDate, true, maxDate, true));
            CvsCSID destcs = null;
            ac ids = q2.asItemSpace(new Query3Params(this.dbh.get(), this.mDB.getCommonStringTables()));
            y cu = y.a();
            while (ids.d(cu)) {
                int csrevid = (int)cu.v(0);
                CvsRevInfo csri = this.mDB.findRevInfo(csrevid);
                CvsCSID cs = CvsCSID.parse(csri.getChangeSetId());
                if (destcs != null && destcs.compareTo(cs) >= 0) continue;
                destcs = cs;
            }
            if (destcs != null && this.mDB.changesetContainsPath(destcs, ri.getPath())) {
                destcs = null;
            }
            if (destcs == null) {
                destcs = this.mDB.createNewChangeSet(ri);
            }
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)(" " + destcs + " -> " + ri.getRevInfoKey()));
            }
            this.mDB.appendToChangeSet(destcs, Collections.singletonList(ri));
            return destcs;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private static class NextDateIterator {
        private final y cu = y.a();
        private final ac db;
        private final int dateOffset;

        public NextDateIterator(ac db) {
            this.db = db;
            this.cu.a(RevInfoEAV.E_CSTODO_TO_REVID);
            this.dateOffset = this.cu.e();
        }

        public boolean hasNextDate() throws DbException {
            try {
                return this.db.a(this.cu, this.dateOffset);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }

        public long nextDate() {
            return this.cu.v(this.dateOffset);
        }

        public IntArrayList nextRevids() throws DbException {
            try {
                int revidAttOffset = this.cu.w(this.dateOffset);
                int revidOffset = this.cu.ab(revidAttOffset);
                IntArrayList result = new IntArrayList();
                do {
                    int revid = (int)this.cu.v(revidOffset);
                    result.add(revid);
                } while (this.db.a(this.cu, revidAttOffset));
                return result;
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
    }

    private static class RevInfoPathComparator
    implements Comparator<CvsRevInfo> {
        public static final RevInfoPathComparator INSTANCE = new RevInfoPathComparator();

        private RevInfoPathComparator() {
        }

        @Override
        public int compare(CvsRevInfo a2, CvsRevInfo b2) {
            int cmp = a2.getPath().compareTo(b2.getPath());
            if (cmp != 0) {
                return 0;
            }
            return a2.getCvsRevision().compareTo(b2.getCvsRevision());
        }
    }
}

