/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.FileChunk;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;

public class RevisionTextReader
extends Reader {
    private final BufferedRandomAccessInputStream file;
    private final String encoding;
    private Iterator<FileChunk> lineIterator;
    private String currentLine = "";
    private int charIndex = 0;

    public RevisionTextReader(Iterable<FileChunk> lines, BufferedRandomAccessInputStream file, Charset charset) {
        this.lineIterator = lines.iterator();
        this.file = file;
        this.encoding = charset.name();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int c2;
        int charsRead;
        if (this.isAtEndOfInput()) {
            return -1;
        }
        for (charsRead = 0; charsRead < len && !this.isAtEndOfInput() && (c2 = this.readChar()) != -1; ++charsRead) {
            cbuf[off + charsRead] = (char)c2;
        }
        return charsRead;
    }

    private int readChar() throws IOException {
        String s2 = this.currentLine();
        if (s2 == null) {
            return -1;
        }
        return s2.charAt(this.charIndex++);
    }

    private String currentLine() throws IOException {
        if (!this.isAtEndOfLine()) {
            return this.currentLine;
        }
        while (this.isAtEndOfLine() && this.hasMoreLines()) {
            this.charIndex = 0;
            this.currentLine = this.readLine();
        }
        if (this.isAtEndOfInput()) {
            this.currentLine = "";
            this.charIndex = 0;
            return null;
        }
        return this.currentLine;
    }

    private String readLine() throws IOException {
        FileChunk line = this.lineIterator.next();
        byte[] buf = new byte[line.getLength()];
        this.file.seek(line.getFpStart());
        int readLength = this.file.read(buf, 0, line.getLength());
        String s2 = new String(buf, 0, readLength, this.encoding);
        if (s2.indexOf(64) != -1) {
            s2 = s2.replaceAll("@(.)", "$1");
        }
        return s2;
    }

    private boolean isAtEndOfInput() {
        return !this.hasMoreLines() && this.isAtEndOfLine();
    }

    private boolean isAtEndOfLine() {
        return this.charIndex >= this.currentLine.length();
    }

    private boolean hasMoreLines() {
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    public void close() throws IOException {
        this.currentLine = "";
        this.charIndex = 0;
        this.lineIterator = null;
    }
}

