/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.Revision;

public class RevisionEdge {
    private final Revision mFrom;
    private final Revision mTo;

    public RevisionEdge(Revision aFrom, Revision aTo) {
        this.mFrom = aFrom;
        this.mTo = aTo;
    }

    public Revision getFrom() {
        return this.mFrom;
    }

    public Revision getTo() {
        return this.mTo;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof RevisionEdge)) {
            return false;
        }
        RevisionEdge edge = (RevisionEdge)o2;
        if (!this.mTo.equals(edge.mTo)) {
            return false;
        }
        return this.mFrom.equals(edge.mFrom);
    }

    public int hashCode() {
        int result = this.mFrom.hashCode();
        result = 29 * result + this.mTo.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.mFrom + "->" + this.mTo + ")";
    }

    public Revision getOther(Revision rev) {
        if (rev.equals(this.mFrom)) {
            return this.mTo;
        }
        if (rev.equals(this.mTo)) {
            return this.mFrom;
        }
        return null;
    }

    public RevisionEdge getReverse() {
        return new RevisionEdge(this.mTo, this.mFrom);
    }
}

