/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import antlr.TokenStreamIOException;
import com.cenqua.fisheye.cvsrep.RcsStringToken;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RcsUtil {
    public static final Pattern DATE_PATTERN = Pattern.compile("^(\\d\\d+)\\.(\\d\\d)\\.(\\d\\d)\\.(\\d\\d)\\.(\\d\\d)\\.(\\d\\d)$");

    public static long parseDate(String aDate) {
        Matcher result = DATE_PATTERN.matcher(aDate);
        if (result.matches()) {
            String year = result.group(1);
            String month = result.group(2);
            String day = result.group(3);
            String hour = result.group(4);
            String min = result.group(5);
            String sec = result.group(6);
            if (year.length() == 1) {
                year = "190" + year;
            } else if (year.length() == 2) {
                year = "19" + year;
            }
            try {
                return DateHelper.componentsToTime(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(min), Integer.parseInt(sec));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static StringBuffer rcsStringToString(RcsStringToken aString, Charset cs, BufferedRandomAccessInputStream aFile) throws TokenStreamIOException {
        StringBuffer stringBuffer;
        RcsStringToken.StringParserInputStream ins = null;
        InputStreamReader in = null;
        try {
            int c2;
            ins = aString.getInputStream(aFile);
            in = new InputStreamReader((InputStream)ins, cs);
            StringBuffer buf = new StringBuffer((int)(aString.getEnd() - aString.getStart()));
            while ((c2 = ((Reader)in).read()) != -1) {
                buf.append((char)c2);
            }
            stringBuffer = buf;
        }
        catch (IOException e2) {
            try {
                Logs.APP_LOG.error((Object)("parsing rcs string in " + aFile.getFile() + " at " + aString.getStart() + "-" + aString.getEnd()), (Throwable)e2);
                throw new TokenStreamIOException(e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                IOHelper.close(ins);
                throw throwable;
            }
        }
        IOHelper.close(in);
        IOHelper.close(ins);
        return stringBuffer;
    }

    public static String formatPrintableDate(long date) {
        StringBuffer buf = new StringBuffer(19);
        int[] components = DateHelper.timeToComponents(date);
        StringUtil.pad(buf, components[0], 4);
        buf.append("/");
        StringUtil.pad(buf, components[1], 2);
        buf.append("/");
        StringUtil.pad(buf, components[2], 2);
        buf.append(" ");
        StringUtil.pad(buf, components[3], 2);
        buf.append(":");
        StringUtil.pad(buf, components[4], 2);
        buf.append(":");
        StringUtil.pad(buf, components[5], 2);
        return buf.toString();
    }
}

