/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.LineCountState;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RcsRevisionInfo
implements CommonFileRevisionInput {
    private final List<String> mSymbols = new ArrayList<String>();
    private int mLineCount;
    private int mLinesAdded;
    private int mLinesRemoved;
    private final Revision mRevision;
    private Date mDate;
    private String mAuthor;
    private String mComment;
    private String mState;
    private RcsRevisionInfo mAncestor;
    private AncestorLink.Type ancestorType;
    private RcsRevisionInfo mNextInBranch;
    private final RcsFileHistory mFile;
    private int revid = -1;
    private boolean newlyAdded;
    private String mThisBranch;
    private List<Hunk> hunks;

    public RcsRevisionInfo(RcsFileHistory file, Revision aRevision) {
        this.mRevision = aRevision;
        this.mFile = file;
    }

    @Override
    public String getChangeSetId() {
        return null;
    }

    @Override
    public int getRevID() {
        return this.revid;
    }

    public void setRevID(int revid) {
        this.revid = revid;
    }

    @Override
    public int getFileType() {
        return 1;
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newlyAdded) {
        this.newlyAdded = newlyAdded;
    }

    @Override
    public String getRevision() {
        return this.mRevision.toString();
    }

    public Revision getCvsRevision() {
        return this.mRevision;
    }

    public RcsFileHistory getFile() {
        return this.mFile;
    }

    @Override
    public Path getPath() {
        return this.getFile().getPath();
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String aState) {
        this.mState = aState;
    }

    @Override
    public boolean isDead() {
        return "dead".equals(this.getState());
    }

    @Override
    public boolean isAdded() {
        RcsRevisionInfo prev = this.getAncestor();
        if (prev != null) {
            return prev.isDead();
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return this.getFile().isBinary();
    }

    @Override
    public String getComment() {
        return this.mComment;
    }

    public void setComment(String aComment) {
        this.mComment = aComment;
    }

    public RcsRevisionInfo getAncestor() {
        return this.mAncestor;
    }

    public void setAncestor(RcsRevisionInfo aAncestor, AncestorLink.Type ancestorType) {
        this.mAncestor = aAncestor;
        this.ancestorType = ancestorType;
    }

    public AncestorLink.Type getAncestorType() {
        return this.ancestorType;
    }

    public String getAncestorRevision() {
        return this.mAncestor == null ? null : this.mAncestor.getRevision();
    }

    public RcsRevisionInfo getNextInBranch() {
        return this.mNextInBranch;
    }

    public void setNextInBranch(RcsRevisionInfo nextInBranch) {
        this.mNextInBranch = nextInBranch;
    }

    @Override
    public long getDate() {
        return this.mDate != null ? this.mDate.getTime() : 0L;
    }

    @Override
    public Date getDateValue() {
        return this.mDate;
    }

    @Override
    public String getAuthor() {
        return this.mAuthor;
    }

    public void setDate(long aDate) {
        this.mDate = new Date(aDate);
    }

    public void setAuthor(String aAuthor) {
        this.mAuthor = aAuthor;
    }

    public List<String> getTags() {
        return this.mSymbols;
    }

    @Override
    public String getBranch() {
        return this.mThisBranch;
    }

    @Override
    public boolean isTrunkLike() {
        return "MAIN".equals(this.mThisBranch);
    }

    @Override
    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getPath(), this.getRevision());
    }

    void setThisBranch(String thisBranch) {
        this.mThisBranch = thisBranch;
    }

    public List<String> getBranches() {
        return this.mFile.getBranches(this.mRevision);
    }

    void addSymbol(String aSym) {
        this.mSymbols.add(aSym);
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    public void setLineCount(int lineCount) {
        this.mLineCount = lineCount;
    }

    @Override
    public int getLinesAdded() {
        return this.mLinesAdded;
    }

    @Override
    public int getLinesRemoved() {
        return this.mLinesRemoved;
    }

    public void setLinesChanged(int linesAdded, int linesRemoved, List<Hunk> hunks) {
        this.mLinesRemoved = linesRemoved;
        this.mLinesAdded = linesAdded;
        this.hunks = hunks;
    }

    @Override
    public LineCountState getLineCountState() {
        return LineCountState.FULL;
    }

    public String toString() {
        return "RcsRevisionInfo[" + this.getFile() + " " + this.getRevision() + "]";
    }

    public RevInfoKey getInfoKey() {
        return new RevInfoKey(this.getFile().getPath(), this.getRevision());
    }

    void fixup() {
        if (this.mAuthor == null) {
            Logs.APP_LOG.warn((Object)("no author for " + this.getFile().getPath() + " " + this.getRevision()));
            this.mAuthor = "UNKNOWN";
        }
        if (this.mComment == null) {
            this.mComment = "";
        }
    }

    @Override
    public boolean isCopy() {
        return false;
    }

    @Override
    public boolean isMove() {
        return false;
    }

    @Override
    public boolean isModify() {
        return true;
    }

    public KeywordExpansion.KeywordExpansionInfo makeKeywordExpansionInfo(String tagname) {
        if (this.getRevision().equals(tagname)) {
            tagname = null;
        }
        return new KeywordExpansion.KeywordExpansionInfo(this.getAuthor(), this.getDate(), this.getRevision(), this.getState(), tagname);
    }

    public KeywordExpansion.KeywordExpansionInfo makeKeywordExpansionInfo() {
        return this.makeKeywordExpansionInfo(null);
    }

    @Override
    public List<Hunk> getHunks() {
        return this.hunks;
    }

    @Override
    public File getTmpDiffAddedFile() {
        return null;
    }

    @Override
    public File getTmpDiffRemovedFile() {
        return null;
    }

    @Override
    public boolean isOversize() {
        return false;
    }

    @Override
    public boolean isBinaryOrOversize() {
        return this.isBinary() || this.isOversize();
    }

    @Override
    public RevInfoKey getPredecessor() {
        return null;
    }

    @Override
    public AncestorLink getAncestorLink() {
        return null;
    }
}

