/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import antlr.ANTLRException;
import antlr.TokenStreamIOException;
import com.cenqua.fisheye.cvsrep.RCSParseListener;
import com.cenqua.fisheye.cvsrep.RcsFileLexer;
import com.cenqua.fisheye.cvsrep.RcsFileParser;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.nio.charset.Charset;

public class RCSParser {
    private static final int MAX_RETRY = 100;

    public static void parse(BufferedRandomAccessInputStream in, Charset cs, RCSParseListener listener) throws ParseException, IOException {
        if (!RCSParser.parseImpl(in, cs, listener)) {
            throw new IOException("File was modifed while parsing: " + in.getFile());
        }
    }

    private static boolean parseImpl(BufferedRandomAccessInputStream in, Charset cs, RCSParseListener listener) throws ParseException, IOException {
        try {
            boolean success;
            long fs0 = in.getFile().length();
            RcsFileLexer aLexer = new RcsFileLexer(in);
            RcsFileParser parser = new RcsFileParser(aLexer, cs, listener);
            parser.parse();
            long fs1 = in.getFile().length();
            boolean bl = success = fs0 == fs1;
            if (!success) {
                Logs.APP_LOG.info((Object)("file was modifed while parsing " + in.getFile() + " " + fs0 + " " + fs1));
            }
            return success;
        }
        catch (TokenStreamIOException e2) {
            Logs.APP_LOG.error((Object)("IO error while parsing " + in.getFile()), (Throwable)e2.io);
            throw e2.io;
        }
        catch (ANTLRException e3) {
            throw new ParseException("error parsing " + in.getFile(), e3);
        }
        catch (Throwable e4) {
            Logs.APP_LOG.error((Object)("internal error while parsing " + in.getFile()), e4);
            throw new ParseException("internal error parsing " + in.getFile(), e4);
        }
    }

    public static void parse(BufferedRandomAccessInputStream in, Charset cs, ListenerFactory lf) throws ParseException, IOException {
        boolean success;
        long fpStart = in.getFilePointer();
        int count = 0;
        do {
            if (count > 0) {
                RCSParser.sleep();
                in.flush();
            }
            in.seek(fpStart);
            RCSParseListener listener = lf.getListener();
            success = RCSParser.parseImpl(in, cs, listener);
        } while (++count < 100 && !success);
        if (!success) {
            throw new IOException("could not parse " + in.getFile() + " after " + count + " retries");
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static interface ListenerFactory {
        public RCSParseListener getListener();
    }

    public static class ParseException
    extends Exception {
        public ParseException(String message) {
            super(message);
        }

        public ParseException(Throwable cause) {
            super(cause);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

