/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.LineWriter;
import com.cenqua.fisheye.cvsrep.RcsUtil;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeywordExpandingLineWriter
implements LineWriter {
    private final Pattern KEYWORD_PATTERN = Pattern.compile("\\$([a-zA-Z]+)(:[^$]*)?\\$");
    public static final String KW_AUTHOR = "Author";
    public static final String KW_DATE = "Date";
    public static final String KW_HEADER = "Header";
    public static final String KW_ID = "Id";
    public static final String KW_LOCKER = "Locker";
    public static final String KW_LOG = "Log";
    public static final String KE_NAME = "Name";
    public static final String KW_RCSFILE = "RCSfile";
    public static final String KW_REVISION = "Revision";
    public static final String KW_SOURCE = "Source";
    public static final String KW_STATE = "State";
    private static final String[] KEYWORDS = new String[]{"Author", "Date", "Header", "Id", "Locker", "Log", "Name", "RCSfile", "Revision", "Source", "State"};
    private final LineWriter mOut;
    private final Matcher mMatcher = this.KEYWORD_PATTERN.matcher("");
    private KeywordExpansion mMode;
    private final KeywordExpansion.KeywordExpansionInfo mInfo;
    private final String mFullPath;
    private final String mFileName;

    public KeywordExpandingLineWriter(KeywordExpansion mode, File realFile, KeywordExpansion.KeywordExpansionInfo info, LineWriter out) {
        this.mOut = out;
        this.mMode = mode;
        this.mInfo = info;
        this.mFullPath = realFile.getAbsoluteFile().getPath().replace('\\', '/');
        this.mFileName = realFile.getName();
    }

    public KeywordExpansion getExpand() {
        return this.mMode;
    }

    public void setExpand(KeywordExpansion mode) {
        this.mMode = mode;
    }

    @Override
    public void writeLine(String line) throws IOException {
        if (this.mMode == null) {
            this.mMode = KeywordExpansion.KFLAG_KV;
        }
        if (this.mMode == KeywordExpansion.KFLAG_O || this.mMode == KeywordExpansion.KFLAG_B) {
            this.mOut.writeLine(line);
            return;
        }
        if (line.indexOf(36) == -1) {
            this.mOut.writeLine(line);
        } else {
            this.processLine(line);
        }
    }

    private void processLine(String srcLine) throws IOException {
        if (srcLine.length() == 0) {
            this.mOut.writeLine(srcLine);
            return;
        }
        StringBuffer line = new StringBuffer(srcLine);
        int start = 0;
        while (start < line.length()) {
            String str;
            this.mMatcher.reset(line);
            if (!this.mMatcher.find(start)) break;
            start += this.mMatcher.start() + 1;
            String name = this.mMatcher.group(1);
            String keyword = null;
            for (String kw : KEYWORDS) {
                if (!kw.equals(name)) continue;
                keyword = kw;
                break;
            }
            if (keyword == null) continue;
            int soKeyword = this.mMatcher.start();
            int eoName = this.mMatcher.end(1);
            int eoKeyword = this.mMatcher.end();
            if (this.mMode == KeywordExpansion.KFLAG_K) {
                line.delete(eoName, eoKeyword - 1);
                eoKeyword = eoName + 1;
                continue;
            }
            if (this.mMode == KeywordExpansion.KFLAG_KV || this.mMode == KeywordExpansion.KFLAG_KVL) {
                str = ": " + this.newKeywordValue(keyword) + " ";
                line.replace(eoName, eoKeyword - 1, str);
                eoKeyword = eoName + str.length() + 1;
                continue;
            }
            if (this.mMode == KeywordExpansion.KFLAG_V) {
                str = this.newKeywordValue(keyword);
                line.replace(soKeyword, eoKeyword, str);
                eoKeyword = soKeyword + str.length();
                continue;
            }
            Logs.APP_LOG.warn((Object)("unexpected k mode " + this.mMode));
        }
        this.mOut.writeLine(line.toString());
    }

    private String outputLog(String logLeader) throws IOException {
        return "";
    }

    private String newKeywordValue(String kw) {
        String locker = null;
        if (kw == KW_AUTHOR) {
            return this.mInfo.getAuthor();
        }
        if (kw == KW_DATE) {
            return RcsUtil.formatPrintableDate(this.mInfo.getDate());
        }
        if (kw == KW_HEADER) {
            return KeywordExpandingLineWriter.escapeKeywordValue(this.mFullPath) + " " + this.mInfo.getRevision() + " " + RcsUtil.formatPrintableDate(this.mInfo.getDate()) + " " + this.mInfo.getAuthor() + " " + this.mInfo.getState() + (locker != null ? " " + locker : "");
        }
        if (kw == KW_ID) {
            return KeywordExpandingLineWriter.escapeKeywordValue(this.mFileName) + " " + this.mInfo.getRevision() + " " + RcsUtil.formatPrintableDate(this.mInfo.getDate()) + " " + this.mInfo.getAuthor() + " " + this.mInfo.getState() + (locker != null ? " " + locker : "");
        }
        if (kw == KW_LOCKER) {
            return locker != null ? locker : "";
        }
        if (kw == KW_LOG) {
            return KeywordExpandingLineWriter.escapeKeywordValue(this.mFileName);
        }
        if (kw == KE_NAME) {
            return this.mInfo.getName() == null ? "" : this.mInfo.getName();
        }
        if (kw == KW_RCSFILE) {
            return KeywordExpandingLineWriter.escapeKeywordValue(this.mFileName);
        }
        if (kw == KW_REVISION) {
            return this.mInfo.getRevision();
        }
        if (kw == KW_SOURCE) {
            return KeywordExpandingLineWriter.escapeKeywordValue(this.mFullPath);
        }
        if (kw == KW_STATE) {
            return this.mInfo.getState();
        }
        Logs.APP_LOG.warn((Object)("internall problem: unknown keyword " + kw));
        return "";
    }

    private static String escapeKeywordValue(String s2) {
        StringBuffer buf = new StringBuffer(s2);
        KeywordExpandingLineWriter.escape(buf, "\\", "\\\\");
        KeywordExpandingLineWriter.escape(buf, "\t", "\\t");
        KeywordExpandingLineWriter.escape(buf, "\n", "\\n");
        KeywordExpandingLineWriter.escape(buf, " ", "\\040");
        KeywordExpandingLineWriter.escape(buf, "$", "\\044");
        return buf.toString();
    }

    private static void escape(StringBuffer buf, String find, String replace) {
        int i2 = 0;
        while (-1 != (i2 = buf.indexOf(find, i2))) {
            buf.replace(i2, i2 + find.length(), replace);
            i2 += replace.length();
        }
    }
}

