/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

public class FileChunk
implements Comparable<FileChunk> {
    private final long fpStart;
    private final int length;
    private final long fpEnd;

    public FileChunk(long fpStart, long fpEnd) {
        this.fpStart = fpStart;
        this.fpEnd = fpEnd;
        this.length = (int)(fpEnd - fpStart);
    }

    public String toString() {
        return this.fpStart + " - " + this.fpEnd;
    }

    public long getFpStart() {
        return this.fpStart;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int compareTo(FileChunk textLine) {
        int cmp = (int)(this.fpStart - textLine.fpStart);
        if (cmp == 0) {
            cmp = this.length - textLine.length;
        }
        return cmp;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof FileChunk)) {
            return false;
        }
        FileChunk textLine = (FileChunk)o2;
        return this.fpStart == textLine.fpStart && this.fpEnd == textLine.fpEnd;
    }

    public int hashCode() {
        int value = (int)this.fpStart;
        value = (int)((long)(value * 23) + this.fpEnd);
        return value;
    }
}

