/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.StringFileChunk;
import com.cenqua.fisheye.io.FilePointerStream;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.StreamLineReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffParser {
    private static final Pattern ADD_DEL_LINE = Pattern.compile("([ad])(\\d+)\\s+(\\d+)\\s*");
    private final StreamLineReader lineReader;

    public DiffParser(StreamLineReader stream) {
        this.lineReader = stream;
    }

    public DiffParser(FilePointerStream aStream) {
        this.lineReader = new StreamLineReader(LineReader.Mode.MODE_UNIX, aStream);
    }

    public void parseHunks(DiffListener aListener) throws IOException {
        StringFileChunk line;
        Matcher matcher = ADD_DEL_LINE.matcher("");
        int skipcount = 0;
        int lineNumber = 0;
        boolean adding = false;
        while ((line = this.lineReader.readLineWithOffsets()) != null) {
            if (skipcount > 0) {
                --skipcount;
                if (!adding) continue;
                aListener.addLine(line, lineNumber);
                ++lineNumber;
                continue;
            }
            adding = false;
            matcher.reset(line.getText());
            if (!matcher.matches()) continue;
            String mode = matcher.group(1);
            int l2 = Integer.parseInt(matcher.group(2));
            int n2 = Integer.parseInt(matcher.group(3));
            boolean isAdd = mode.equals("a");
            if (isAdd) {
                skipcount = n2;
                aListener.startAdd(l2, n2);
                adding = true;
                lineNumber = l2;
                continue;
            }
            aListener.delete(l2, n2);
        }
    }

    public static interface DiffListener {
        public void delete(int var1, int var2);

        public void startAdd(int var1, int var2);

        public void addLine(StringFileChunk var1, int var2);
    }
}

