/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.scmapi.BaseScmConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.CvsUpdaterType;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.util.IntervalUtils;
import java.io.File;
import java.nio.charset.Charset;

public class CvsScmConfig
extends BaseScmConfig {
    public static final int CACHE_VERSION = 21;
    public static final Charset DEFAULT_CVS_ENCODING = Charset.forName("ISO-8859-1");
    private File mHistoryFile;
    private long mFullScanPeriod = 900000L;
    private long pollPeriod = 5000L;
    private String mHistoryStripPrefix;
    private Charset mCharset = DEFAULT_CVS_ENCODING;
    private File mCvsRoot;
    private final CvsRepType cvsConfig;

    public CvsScmConfig(String name, RootConfig rootConfig, RepositorySystemType scmConfig) {
        super(21, rootConfig);
        this.cvsConfig = (CvsRepType)scmConfig;
        if (this.cvsConfig == null) {
            throw new IllegalStateException(name + " did not contain expected <cvs>");
        }
        this.mCvsRoot = new File(this.cvsConfig.getDir());
        this.mHistoryFile = new File(this.mCvsRoot, "CVSROOT/history");
        if (!this.mCvsRoot.isDirectory()) {
            this.setConfigException("Unable to find repository root: " + this.mCvsRoot);
        }
        this.setup();
    }

    @Override
    public CvsRepositoryEngine createRepositoryEngine(RepositoryConfig repoConfig, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        return new CvsRepositoryEngine(repoConfig, upgradeManager, indexingContext);
    }

    private void setup() {
        if (this.cvsConfig.isSetCharset()) {
            String cs = this.cvsConfig.getCharset();
            try {
                this.mCharset = Charset.forName(cs);
            }
            catch (IllegalArgumentException e2) {
                this.setConfigException(new ConfigException("Not a valid encoding name: '" + cs + "'. Valid names are " + Charset.availableCharsets().keySet(), e2));
            }
        }
        this.reloadUpdateSettings();
    }

    @Override
    public void reloadUpdateSettings() {
        if (this.defaults != null && this.defaults.isSetUpdater()) {
            this.parseUpdaterType(this.defaults.getUpdater().getCvs());
        }
        if (this.cvsConfig.isSetUpdater()) {
            this.parseCvsUpdater(this.cvsConfig.getUpdater());
        }
    }

    private void parseCvsUpdater(CvsUpdaterType e2) {
        CvsUpdaterType.Historyfile historyFile = e2.getHistoryfile();
        String fname = historyFile.getFile();
        if (fname != null) {
            this.mHistoryFile = CvsScmConfig.maybeRelativeFile(this.mCvsRoot, fname);
        }
        this.parseUpdaterType(e2);
        String prefix = historyFile.getStripPrefix();
        if (prefix != null) {
            this.mHistoryStripPrefix = prefix;
        }
    }

    private void parseUpdaterType(CvsUpdaterType e2) {
        this.mFullScanPeriod = IntervalUtils.convertStringToLongOrNever(e2.getHistoryfile().getFullScanPeriod(), this.mFullScanPeriod);
        if (e2.isSetPollPeriod()) {
            this.pollPeriod = IntervalUtils.convertStringToLongOrNever(e2.getPollPeriod(), this.pollPeriod);
        }
    }

    private static File maybeRelativeFile(File relativeTo, String fname) {
        File f2 = new File(fname);
        if (!f2.isAbsolute()) {
            f2 = new File(relativeTo, fname);
        }
        return f2;
    }

    public File getCvsRoot() {
        return this.mCvsRoot;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public File getHistoryFile() {
        return this.mHistoryFile;
    }

    public long getFullScanPeriod() {
        return this.mFullScanPeriod;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    public String getHistoryStripPrefix() {
        return this.mHistoryStripPrefix;
    }

    @Override
    public void testConnection(RepositoryConfig config) {
        Logs.APP_LOG.debug((Object)("Testing CVS connection to: " + this.getCvsRoot()));
        Logs.APP_LOG.debug((Object)("Using history file location: " + this.getHistoryFile()));
        File historyFile = this.getHistoryFile();
        if (historyFile == null) {
            Logs.APP_LOG.debug((Object)"No history file configured.");
        } else if (!this.getHistoryFile().exists()) {
            Logs.APP_LOG.warn((Object)("History file: '" + historyFile.getAbsolutePath() + "' does not exist."));
        }
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.CVS;
    }
}

