/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.cvsrep.cache.CvsScanner;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.io.IOException;

public class CvsRepositoryEngine
extends RepositoryEngine {
    private CvsScanner scanner;
    private CvsCache cache;
    private final CvsScmConfig cvsConfig;

    public CvsRepositoryEngine(RepositoryConfig config, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        super(config, upgradeManager, indexingContext);
        this.cvsConfig = (CvsScmConfig)config.getScmConfig();
    }

    @Override
    public void requestStop() {
    }

    @Override
    public void doStart(long cacheSerial) throws IOException, DbException {
        InfDbRevisionInfoCache revisionInfoCache = new InfDbRevisionInfoCache(this.getCfg(), this.getIndexingContext(), this.getDatabaseHandle(), this.getLicenseEnforcer());
        revisionInfoCache.setCaseSensitive(true);
        revisionInfoCache.open();
        CvsRepository repository = new CvsRepository(this.getCfg());
        this.cache = new CvsCache(cacheSerial, this.getCfg().getSoftwareCacheVersion(), revisionInfoCache, this.getIndexConnection(), repository, this.getCfg(), this.getIndexer(), this.getLicenseEnforcer(), this.getPathMatcher(), this.getIndexingContext(), this.getStatus());
        this.scanner = new CvsScanner(this.getCfg(), this.cache, this.getIndexingContext(), this.getLinecountCalculator());
    }

    @Override
    public boolean isLicenseLimitReached() {
        return this.scanner.isLicenseLimitReached();
    }

    @Override
    public void init() {
    }

    @Override
    public String rescan(String start, String end) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Rescan is not supported on CVS repositories");
    }

    @Override
    public void doSlurp() throws DbException, ConfigException {
        this.scanner.ping();
        this.cache.setInitialIndexingComplete(true);
    }

    @Override
    protected long getPollPeriod() {
        return this.cvsConfig.getPollPeriod();
    }

    public CvsCache getRevisionCache() {
        return this.cache;
    }

    @Override
    public void requestFullscan() {
        this.scanner.requestFullscan();
    }

    @Override
    public String getLink(RevInfoKey revInfoKey) {
        return "-d :local:" + this.getRevisionCache().getRepository().getRootDir() + " -r " + revInfoKey.getRev() + " " + revInfoKey.getPath().getPath();
    }

    public InternalRevisionCache<?> getInternalRevisionCache() {
        return this.cache;
    }

    @Override
    protected void resetScmMetaData() {
        this.scanner.resetScmMetaData();
    }

    @Override
    public CvsScanner getScanner() {
        return this.scanner;
    }
}

