/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.KeywordExpandingLineWriter;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.OutputStreamLineWriter;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.RevisionExtractor;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class CvsRepository {
    private static final Path[] EMPTY_PATH_ARRAY = new Path[0];
    private final File rootDir;
    private final String mName;
    private final AllowRules allowRules;
    private final Charset mCharset;

    public CvsRepository(String name, AllowRules allowRules, File rootDir, Charset cs) {
        this.rootDir = rootDir;
        this.mName = name;
        this.allowRules = allowRules;
        this.mCharset = cs;
    }

    public CvsRepository(RepositoryConfig cfg) {
        CvsScmConfig cvsConfig = (CvsScmConfig)cfg.getScmConfig();
        this.rootDir = cvsConfig.getCvsRoot();
        this.mName = cfg.getName();
        this.allowRules = cfg.getAllowRules();
        this.mCharset = cvsConfig.getCharset();
    }

    public String getName() {
        return this.mName;
    }

    public Path[] listFiles(Path dir) {
        File attic;
        if (this.allowRules.isIgnored(dir)) {
            return EMPTY_PATH_ARRAY;
        }
        LinkedHashSet<Path> list = new LinkedHashSet<Path>();
        File d2 = new File(this.rootDir, dir.getPath());
        File[] files = d2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(",v");
            }
        });
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                Path path = new Path(dir, name.substring(0, name.length() - 2));
                if (this.allowRules.isIgnored(path)) continue;
                list.add(path);
            }
        }
        if ((files = (attic = new File(d2, "Attic")).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(",v");
            }
        })) != null) {
            for (File file : files) {
                String name = file.getName();
                Path path = new Path(dir, name.substring(0, name.length() - 2));
                if (this.allowRules.isIgnored(path)) continue;
                if (list.contains(path)) {
                    CvsRepository.warnDuplicateInAttic(name, path);
                    continue;
                }
                list.add(path);
            }
        }
        Object[] paths = new Path[list.size()];
        list.toArray(paths);
        Arrays.sort(paths);
        return paths;
    }

    private static void warnDuplicateInAttic(String name, Path path) {
        if (Logs.Warnings.warnOnDupicatesInAttic) {
            Logs.APP_LOG.warn((Object)("[" + name + "] File appeared both in directory and Attic, ignoring version in Attic: " + path));
            if (Logs.Warnings.warnOnDupicatesInAtticJustOnce) {
                Logs.APP_LOG.warn((Object)("[" + name + "] This warning about duplicated Attic files will not appear again."));
                Logs.Warnings.warnOnDupicatesInAttic = false;
            }
        }
    }

    public File getFilesystemFileForPath(Path aPath) throws FileNotFoundException {
        if (this.allowRules.isIgnored(aPath)) {
            throw new FileNotFoundException("not found");
        }
        File file = new File(this.rootDir, aPath.getPath() + ",v");
        if (file.isFile()) {
            return file;
        }
        File dir = new File(this.rootDir, aPath.getParent().getPath());
        File attic = new File(dir, "Attic");
        file = new File(attic, aPath.getName() + ",v");
        if (file.isFile()) {
            return file;
        }
        throw new FileNotFoundException("could not find " + aPath + " (even tried Attic)");
    }

    public RcsFileHistory getFileHistoryInfo(Path path) throws IOException, RCSParser.ParseException {
        RcsFileHistoryFactory.Result res = this.getFileHistory(path);
        return res == null ? null : res.getHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RcsFileHistoryFactory.Result getFileHistory(Path path) throws IOException, RCSParser.ParseException {
        RcsFileHistoryFactory.Result result;
        if (this.allowRules.isIgnored(path)) {
            return null;
        }
        BufferedRandomAccessInputStream in = null;
        try {
            File file = this.getFilesystemFileForPath(path);
            in = new BufferedRandomAccessInputStream(file);
            result = RcsFileHistoryFactory.createHistory(in, this.getCharset(), path);
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
        return result;
    }

    public Path[] listDirs(Path dir) {
        if (this.allowRules.isIgnored(dir)) {
            return EMPTY_PATH_ARRAY;
        }
        ArrayList<Path> list = new ArrayList<Path>();
        File d2 = new File(this.rootDir, dir.getPath());
        File[] files = d2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals("Attic");
            }
        });
        if (files == null) {
            return EMPTY_PATH_ARRAY;
        }
        for (File file : files) {
            Path path = new Path(dir, file.getName());
            if (this.allowRules.isIgnored(path)) continue;
            list.add(path);
        }
        Object[] paths = list.toArray(new Path[list.size()]);
        Arrays.sort(paths);
        return paths;
    }

    public boolean isDir(Path aPath) {
        if (this.allowRules.isIgnored(aPath)) {
            return false;
        }
        File path = new File(this.rootDir, aPath.getPath());
        return path.isDirectory() && !path.getName().equalsIgnoreCase("Attic");
    }

    public boolean isFile(Path aPath) {
        if (this.allowRules.isIgnored(aPath)) {
            return false;
        }
        try {
            File file = this.getFilesystemFileForPath(aPath);
            return file.isFile();
        }
        catch (FileNotFoundException e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTextRevision(Path path, Revision rev, KeywordExpansion.KeywordExpansionInfo aInfo, OutputStream aOut, KeywordExpansion kopt) throws IOException, RCSParser.ParseException {
        if (this.allowRules.isIgnored(path)) {
            throw new FileNotFoundException("not found");
        }
        BufferedRandomAccessInputStream stream = null;
        try {
            File file = this.getFilesystemFileForPath(path);
            stream = new BufferedRandomAccessInputStream(file);
            KeywordExpandingLineWriter kout = new KeywordExpandingLineWriter(kopt, file, aInfo, new OutputStreamLineWriter(aOut));
            RevisionExtractor.extractRevision(stream, this.mCharset, rev, kout);
        }
        catch (Throwable throwable) {
            IOHelper.close(stream);
            throw throwable;
        }
        IOHelper.close(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBinaryRevision(Path aPath, Revision aRev, OutputStream aOut) throws IOException, RCSParser.ParseException {
        if (this.allowRules.isIgnored(aPath)) {
            throw new FileNotFoundException("not found");
        }
        BufferedRandomAccessInputStream stream = null;
        try {
            File file = this.getFilesystemFileForPath(aPath);
            stream = new BufferedRandomAccessInputStream(file);
            RevisionExtractor.extractRevision(stream, this.mCharset, aRev, new OutputStreamLineWriter(aOut));
        }
        catch (Throwable throwable) {
            IOHelper.close(stream);
            throw throwable;
        }
        IOHelper.close(stream);
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public File getRootDir() {
        return this.rootDir;
    }
}

