/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.Chunk;
import com.cenqua.fisheye.cvsrep.FileChunk;
import com.cenqua.fisheye.cvsrep.LineInfoListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChunkList
implements Iterable<Chunk> {
    private final List<Chunk> mHunks = new ArrayList<Chunk>();

    public void addDelete(int aLine, int aCount) {
        this.mHunks.add(new Chunk(false, aLine, aCount));
    }

    public void addAdd(int aLine, int aCount) {
        this.mHunks.add(new Chunk(true, aLine, aCount));
    }

    public String toString() {
        return this.mHunks.toString();
    }

    @Override
    public Iterator<Chunk> iterator() {
        return this.mHunks.iterator();
    }

    public int size() {
        return this.mHunks.size();
    }

    public Chunk getChunk(int i2) {
        return this.mHunks.get(i2);
    }

    public Chunk[] asArray() {
        Chunk[] chunkArray = new Chunk[this.mHunks.size()];
        this.mHunks.toArray(chunkArray);
        return chunkArray;
    }

    public void addLine(FileChunk textLine) {
        this.mHunks.get(this.mHunks.size() - 1).addLine(textLine);
    }

    public List<FileChunk> getAddedLines() {
        ArrayList<FileChunk> added = new ArrayList<FileChunk>();
        for (Chunk chunk : this.mHunks) {
            added.addAll(chunk.getText());
        }
        return added;
    }

    public void applyHunksToSpans(LineInfoListener lines, boolean reverse) {
        int doffset = reverse ? 1 : 0;
        int aoffset = reverse ? 0 : 1;
        int offset = 0;
        for (Chunk hunk : this) {
            boolean isAdd = hunk.isAdd() ^ reverse;
            int count = hunk.getCount();
            if (isAdd) {
                lines.addLines(offset + aoffset, hunk);
                offset += reverse ? 0 : count;
                continue;
            }
            lines.removeLines(offset + doffset, hunk);
            offset -= reverse ? 0 : count;
        }
    }
}

