/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.FileChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Chunk {
    private final boolean mIsAdd;
    private final int mLine;
    private final int mCount;
    private final List<FileChunk> text;

    public Chunk(boolean aAdd, int aLine, int aCount) {
        this.mIsAdd = aAdd;
        this.mLine = aLine;
        this.mCount = aCount;
        this.text = this.mIsAdd ? new ArrayList<FileChunk>(this.mCount) : Collections.emptyList();
    }

    public boolean isAdd() {
        return this.mIsAdd;
    }

    public boolean isDelete() {
        return !this.isAdd();
    }

    public int getLine() {
        return this.mLine;
    }

    public int getCount() {
        return this.mCount;
    }

    public String toString() {
        return (this.isAdd() ? "a" : "d") + this.mLine + ":" + this.mCount;
    }

    public List<FileChunk> getText() {
        return this.text;
    }

    public void addLine(FileChunk line) {
        this.text.add(line);
    }

    public static class ChunkComparer
    implements Comparator<Chunk> {
        @Override
        public int compare(Chunk chunk1, Chunk chunk2) {
            return 4 * (chunk1.getLine() - chunk2.getLine()) + (chunk2.isAdd() ? -1 : 1) + (chunk1.isAdd() ? 1 : -1);
        }
    }
}

