/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.Chunk;
import com.cenqua.fisheye.cvsrep.ChunkList;
import com.cenqua.fisheye.cvsrep.DiffParser;
import com.cenqua.fisheye.cvsrep.FileChunk;
import com.cenqua.fisheye.cvsrep.LineInfoListener;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.RevisionEdge;
import com.cenqua.fisheye.cvsrep.RevisionTextReader;
import com.cenqua.fisheye.cvsrep.StringFileChunk;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.FilePointerStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.StreamLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ChangeTree {
    private final Map<RevisionEdge, ChunkList> mEdgeMap = new HashMap<RevisionEdge, ChunkList>();
    private final SetMultimap<Revision, RevisionEdge> mFromEdgeMap = HashMultimap.create();
    private int mHeadLines = 0;
    private int mHeadBytes = 0;
    private Revision mHeadRev;
    private final List<FileChunk> headText = new ArrayList<FileChunk>();
    private final File fileSystemFile;
    private final Charset charSet;
    private BufferedRandomAccessInputStream fileStream;
    private final Map<Revision, Node> mNodes = new HashMap<Revision, Node>();

    public ChangeTree(File fileSystemFile, Charset charSet) {
        this.fileSystemFile = fileSystemFile;
        this.charSet = charSet;
    }

    public List<Revision> getAncestors(Revision aRev) {
        LinkedList<Revision> list = new LinkedList<Revision>();
        Revision rev = aRev;
        while (rev != null) {
            list.add(0, rev);
            Node node = this.getNode(rev);
            rev = node.getAncestor();
        }
        return list;
    }

    void addRevision(Revision aRev) {
        Node node = new Node(aRev);
        this.mNodes.put(aRev, node);
    }

    void setupAncestor(Revision aDescendant, Revision aAncestor) {
        Node node = this.getNode(aDescendant);
        node.setAncestor(aAncestor);
    }

    void setDeltaText(Revision aFrom, Revision aTo, FilePointerStream in) throws IOException {
        RevisionEdge edge = new RevisionEdge(aFrom, aTo);
        final ChunkList hunks = new ChunkList();
        this.mEdgeMap.put(edge, hunks);
        this.mFromEdgeMap.put((Object)aFrom, (Object)edge);
        if (in != null) {
            DiffParser parser = new DiffParser(in);
            parser.parseHunks(new DiffParser.DiffListener(){

                @Override
                public void delete(int line, int count) {
                    hunks.addDelete(line, count);
                }

                @Override
                public void startAdd(int line, int count) {
                    hunks.addAdd(line, count);
                }

                @Override
                public void addLine(StringFileChunk line, int lineNumber) {
                    hunks.addLine(line.getFileChunk());
                }
            });
        }
    }

    void setHeadText(Revision aRevision, FilePointerStream aIn) throws IOException {
        this.mHeadRev = aRevision;
        if (aIn != null) {
            StringFileChunk line;
            StreamLineReader reader = new StreamLineReader(LineReader.Mode.MODE_UNIX, aIn);
            this.mHeadLines = 0;
            this.mHeadBytes = 0;
            while ((line = reader.readLineWithOffsets()) != null) {
                this.headText.add(line.getFileChunk());
                ++this.mHeadLines;
                this.mHeadBytes += line.getText().length();
            }
        }
    }

    public Node getNode(Revision aRev) {
        return this.mNodes.get(aRev);
    }

    public ChunkList getChange(RevisionEdge edge) {
        return this.mEdgeMap.get(edge);
    }

    public int getHeadBytes() {
        return this.mHeadBytes;
    }

    void postProcess(Map<Revision, RcsRevisionInfo> revMap) {
        if (this.mHeadRev == null) {
            return;
        }
        this.computeLines(this.mHeadRev, this.mHeadLines);
        for (Map.Entry<Revision, RcsRevisionInfo> entry : revMap.entrySet()) {
            Revision rev = entry.getKey();
            RcsRevisionInfo info = entry.getValue();
            Node node = this.getNode(rev);
            info.setLineCount(node.getLineCount());
            Revision ancestor = node.getAncestor();
            if (ancestor != null) {
                RevisionEdge edge = new RevisionEdge(ancestor, rev);
                if (!this.mEdgeMap.containsKey(edge)) {
                    Node ancestorNode = this.getNode(ancestor);
                    info.setLinesChanged(ancestorNode.getLinesRemoved(), ancestorNode.getLinesAdded(), this.reverseHunks(ancestorNode.getHunks()));
                    continue;
                }
                info.setLinesChanged(node.getLinesAdded(), node.getLinesRemoved(), node.getHunks());
                continue;
            }
            ArrayList<Hunk> hunks = new ArrayList<Hunk>();
            hunks.add(Hunk.createUnifiedAddHunk(1, 1, node.getLineCount()));
            info.setLinesChanged(node.getLineCount(), 0, hunks);
        }
        for (RcsRevisionInfo info : revMap.values()) {
            RcsRevisionInfo ancestor = info.getAncestor();
            if (info.isDead()) {
                int oldCount = info.getLineCount();
                info.setLineCount(0);
                if (ancestor == null) {
                    info.setLinesChanged(0, 0, Collections.emptyList());
                    continue;
                }
                ArrayList<Hunk> hunks = new ArrayList<Hunk>();
                hunks.add(Hunk.createUnifiedDeleteHunk(1, 1, oldCount));
                info.setLinesChanged(0, oldCount, hunks);
                continue;
            }
            if (ancestor == null || !ancestor.isDead()) continue;
            ArrayList<Hunk> hunks = new ArrayList<Hunk>();
            hunks.add(Hunk.createUnifiedAddHunk(1, 1, info.getLineCount()));
            info.setLinesChanged(info.getLineCount(), 0, hunks);
        }
    }

    private List<Hunk> reverseHunks(List<Hunk> hunks) {
        ArrayList<Hunk> revHunks = new ArrayList<Hunk>();
        for (Hunk hunk : hunks) {
            revHunks.add(hunk.getReverse());
        }
        return revHunks;
    }

    private void computeLines(Revision aStartRevision, int aStartLines) {
        LinkedList<Node> leftToProcess = new LinkedList<Node>();
        Node firstNode = this.getNode(aStartRevision);
        firstNode.setLineCount(aStartLines);
        leftToProcess.addFirst(firstNode);
        while (!leftToProcess.isEmpty()) {
            Node node = (Node)leftToProcess.removeFirst();
            Revision nodeRev = node.getRevision();
            Set edges = this.mFromEdgeMap.get((Object)nodeRev);
            if (edges == null) continue;
            for (RevisionEdge edge : edges) {
                leftToProcess.addLast(this.processEdge(edge, node));
            }
        }
    }

    public Node processEdge(RevisionEdge edge, Node node) {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        Chunk[] chunkArray = this.mEdgeMap.get(edge).asArray();
        Arrays.sort(chunkArray, new Chunk.ChunkComparer());
        boolean skipNext = false;
        int added = 0;
        int removed = 0;
        for (int i2 = 0; i2 < chunkArray.length; ++i2) {
            Chunk nextChunk;
            if (skipNext) {
                skipNext = false;
                continue;
            }
            Chunk chunk = chunkArray[i2];
            int oldLine = chunk.getLine();
            int newLine = oldLine + added - removed;
            int count = chunk.getCount();
            if (i2 < chunkArray.length - 1 && chunkArray[i2 + 1].getLine() == oldLine) {
                nextChunk = chunkArray[i2 + 1];
                skipNext = true;
                hunks.add(new Hunk(oldLine, newLine, count, nextChunk.getCount()));
                removed += count;
                added += nextChunk.getCount();
                continue;
            }
            if (chunk.isDelete() && i2 < chunkArray.length - 1 && chunkArray[i2 + 1].getLine() >= oldLine && chunkArray[i2 + 1].getLine() < oldLine + count) {
                nextChunk = chunkArray[i2 + 1];
                skipNext = true;
                hunks.add(new Hunk(oldLine, newLine, count, nextChunk.getCount()));
                removed += count;
                added += nextChunk.getCount();
                continue;
            }
            if (chunk.isAdd()) {
                hunks.add(Hunk.createUnifiedAddHunk(oldLine + 1, newLine + 1, count));
                added += count;
                continue;
            }
            if (!chunk.isDelete()) continue;
            hunks.add(Hunk.createUnifiedDeleteHunk(oldLine, newLine, count));
            removed += count;
        }
        int count = node.getLineCount() + added - removed;
        Node nextNode = this.getNode(edge.getTo());
        nextNode.setLineCounts(added, removed);
        nextNode.setLineCount(count);
        nextNode.setHunks(hunks);
        return nextNode;
    }

    public int getNumberOfChildren(Revision rev) {
        int count = 0;
        for (RevisionEdge edge : this.mEdgeMap.keySet()) {
            Revision from = edge.getFrom();
            Revision to = edge.getTo();
            int compare = to.compareTo(from);
            if ((!rev.equals(from) || compare <= 0) && (!rev.equals(to) || compare >= 0)) continue;
            ++count;
        }
        return count;
    }

    public List<FileChunk> getRevisionText(Revision targetRev) throws DiffTextException {
        ArrayList<FileChunk> lines = new ArrayList<FileChunk>(this.headText);
        if (!this.mHeadRev.equals(targetRev)) {
            List<RevisionEdge> edges = this.getEdgeList(targetRev, this.mHeadRev);
            for (RevisionEdge edge : edges) {
                this.applyChunklist(lines, edge);
            }
        }
        return lines;
    }

    private List<FileChunk> applyChunklist(final List<FileChunk> lines, RevisionEdge edge) {
        ChunkList chunkList = this.mEdgeMap.get(edge);
        final ArrayList<FileChunk> deletedLines = new ArrayList<FileChunk>();
        chunkList.applyHunksToSpans(new LineInfoListener(){

            @Override
            public void addLines(int offset, Chunk chunk) {
                lines.addAll(offset + chunk.getLine() - 1, chunk.getText());
            }

            @Override
            public void removeLines(int offset, Chunk chunk) {
                int line = chunk.getLine() + offset - 1;
                List sublist = lines.subList(line, line + chunk.getCount());
                deletedLines.addAll(sublist);
                sublist.clear();
            }
        }, false);
        return deletedLines;
    }

    public Pair<Set<FileChunk>, Set<FileChunk>> getDiffText(RcsRevisionInfo rev) throws DiffTextException {
        TreeSet<FileChunk> addedLines = new TreeSet<FileChunk>();
        TreeSet<FileChunk> removedLines = new TreeSet<FileChunk>();
        if (rev.getAncestor() == null) {
            List<FileChunk> lines = this.getRevisionText(rev.getCvsRevision());
            addedLines.addAll(lines);
        } else {
            RevisionEdge edge;
            boolean isReversed;
            RevisionEdge edgeForward = new RevisionEdge(rev.getAncestor().getCvsRevision(), rev.getCvsRevision());
            RevisionEdge edgeBackward = edgeForward.getReverse();
            if (this.mEdgeMap.containsKey(edgeForward)) {
                isReversed = false;
                edge = edgeForward;
            } else if (this.mEdgeMap.containsKey(edgeBackward)) {
                isReversed = true;
                edge = edgeBackward;
            } else {
                return Pair.newInstance(addedLines, removedLines);
            }
            List<FileChunk> lines = this.getRevisionText(edge.getFrom());
            List<FileChunk> deletedLines = this.applyChunklist(lines, edge);
            if (isReversed) {
                addedLines.addAll(deletedLines);
                removedLines.addAll(this.mEdgeMap.get(edge).getAddedLines());
            } else {
                removedLines.addAll(deletedLines);
                addedLines.addAll(this.mEdgeMap.get(edge).getAddedLines());
            }
        }
        return Pair.newInstance(addedLines, removedLines);
    }

    protected List<RevisionEdge> getEdgeList(Revision targetRev, Revision startRev) throws DiffTextException {
        if (targetRev.equals(startRev)) {
            return Collections.emptyList();
        }
        LinkedList<RevisionEdge> path = new LinkedList<RevisionEdge>();
        List<RevisionEdge> branchEdges = this.getBranchEdges(targetRev);
        Revision start = startRev;
        for (RevisionEdge branchEdge : branchEdges) {
            path.addAll(this.getEdgesListOnSameBranch(branchEdge.getFrom(), start));
            path.add(branchEdge);
            start = branchEdge.getTo();
        }
        path.addAll(this.getEdgesListOnSameBranch(targetRev, start));
        return path;
    }

    private List<RevisionEdge> getEdgesListOnSameBranch(Revision targetRev, Revision startRev) throws DiffTextException {
        LinkedList<RevisionEdge> path = new LinkedList<RevisionEdge>();
        Revision rev = startRev;
        while (rev != null && !rev.equals(targetRev)) {
            RevisionEdge nextEdge = null;
            for (RevisionEdge edge : this.mFromEdgeMap.get((Object)rev)) {
                if (rev.getNumCount() != edge.getTo().getNumCount()) continue;
                nextEdge = edge;
            }
            if (nextEdge == null) {
                throw new DiffTextException("Failed to find path from " + startRev + " to " + targetRev);
            }
            path.add(nextEdge);
            rev = nextEdge.getTo();
        }
        return path;
    }

    private List<RevisionEdge> getBranchEdges(Revision targetRev) throws DiffTextException {
        LinkedList<RevisionEdge> branchEdges = new LinkedList<RevisionEdge>();
        Revision rev = targetRev;
        Revision branchpoint = rev.getBranchPointRevision2();
        while (!rev.equals(branchpoint) && branchpoint.getNumCount() > 1) {
            RevisionEdge edge = this.getBranchEdge(branchpoint, rev);
            if (edge == null) {
                throw new DiffTextException("Error getting branch edges for " + targetRev + " in file " + this.fileSystemFile + ", partial list: " + branchEdges);
            }
            branchEdges.add(0, edge);
            rev = branchpoint;
            branchpoint = rev.getBranchPointRevision2();
        }
        return branchEdges;
    }

    public RevisionEdge getBranchEdge(Revision branchpoint, Revision target) throws DiffTextException {
        for (RevisionEdge edge : this.mFromEdgeMap.get((Object)branchpoint)) {
            Revision edgeTo = edge.getTo();
            if (edgeTo.commonPrefixCount(target) < branchpoint.getNumCount() + 1) continue;
            return edge;
        }
        throw new DiffTextException("Count not find path to " + target + " from branchpoint " + branchpoint + " in file " + this.fileSystemFile + ": " + this.mFromEdgeMap.get((Object)branchpoint));
    }

    public boolean initFileStream() {
        try {
            if (this.fileStream == null) {
                this.fileStream = new BufferedRandomAccessInputStream(this.fileSystemFile);
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)"Error creating ChangetTree BufferedRandomAccessInputStream", (Throwable)e2);
            this.fileStream = null;
            return false;
        }
        return true;
    }

    public void closeFileStream() {
        IOHelper.close(this.fileStream);
    }

    public Reader getRevisionReader(Revision cvsRevision) throws DiffTextException {
        return this.getReader(this.getRevisionText(cvsRevision));
    }

    public Reader getHeadTextReader() {
        return this.getReader(this.headText);
    }

    public List<DiffTextReaders> getNewDiffTextReaders(Collection<RcsRevisionInfo> revisions) {
        ArrayList<DiffTextReaders> readerList = new ArrayList<DiffTextReaders>();
        for (RcsRevisionInfo rev : revisions) {
            if (!rev.isNewlyAdded()) continue;
            try {
                Pair<Set<FileChunk>, Set<FileChunk>> lines = this.getDiffText(rev);
                DiffTextReaders readers = new DiffTextReaders(rev);
                readerList.add(readers);
                readers.setAdded(this.getReader((Collection<FileChunk>)lines.getFirst()));
                readers.setRemoved(this.getReader((Collection<FileChunk>)lines.getSecond()));
            }
            catch (DiffTextException e2) {
                Logs.APP_LOG.error((Object)("Error calculating diff text for " + rev + " in file " + this.fileSystemFile), (Throwable)e2);
            }
        }
        return readerList;
    }

    private RevisionTextReader getReader(Collection<FileChunk> lines) {
        if (lines == null || lines.isEmpty() || this.fileStream == null) {
            return null;
        }
        return new RevisionTextReader(lines, this.fileStream, this.charSet);
    }

    public static class DiffTextException
    extends Exception {
        public DiffTextException(String message) {
            super(message);
        }
    }

    public static class DiffTextReaders {
        private Reader added;
        private Reader removed;
        private final RcsRevisionInfo rev;

        public DiffTextReaders(RcsRevisionInfo rev) {
            this.rev = rev;
        }

        public void setAdded(RevisionTextReader added) {
            this.added = added;
        }

        public void setRemoved(RevisionTextReader removed) {
            this.removed = removed;
        }

        public Reader getAdded() {
            return this.added;
        }

        public Reader getRemoved() {
            return this.removed;
        }

        public RcsRevisionInfo getRev() {
            return this.rev;
        }
    }

    public static class Node {
        private final Revision mRevision;
        private int mLineCount;
        private int mLinesAdded;
        private int mLinesRemoved;
        private Revision mAncestor;
        private List<Hunk> hunks;

        public Node(Revision aRevision) {
            this.mRevision = aRevision;
        }

        public Revision getRevision() {
            return this.mRevision;
        }

        public int getLineCount() {
            return this.mLineCount;
        }

        void setLineCount(int aLineCount) {
            this.mLineCount = aLineCount;
        }

        void setLineCounts(int added, int removed) {
            this.mLinesAdded = added;
            this.mLinesRemoved = removed;
        }

        public int getLinesAdded() {
            return this.mLinesAdded;
        }

        public int getLinesRemoved() {
            return this.mLinesRemoved;
        }

        public Revision getAncestor() {
            return this.mAncestor;
        }

        void setAncestor(Revision aAncestor) {
            this.mAncestor = aAncestor;
        }

        public int hashCode() {
            return this.mRevision.hashCode();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Node)) {
                return false;
            }
            Node node = (Node)o2;
            return this.mRevision.equals(node.mRevision);
        }

        public void setHunks(List<Hunk> hunks) {
            this.hunks = hunks;
        }

        public List<Hunk> getHunks() {
            return this.hunks;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Revision ").append(this.mRevision == null ? "null" : this.mRevision);
            sb.append(", ancestor ").append(this.mAncestor == null ? "null" : this.mAncestor);
            sb.append(", linecount ").append(this.mLineCount);
            sb.append(", added ").append(this.mLinesAdded);
            sb.append(", removed ").append(this.mLinesRemoved);
            sb.append(", diff hunks ").append(this.hunks == null ? "null" : this.hunks);
            return sb.toString();
        }
    }
}

