/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.ChangeTree;
import com.cenqua.fisheye.cvsrep.Chunk;
import com.cenqua.fisheye.cvsrep.ChunkList;
import com.cenqua.fisheye.cvsrep.LineInfoListener;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.RevisionEdge;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Annotator {
    private final ChangeTree mTree;
    private final LineInfos mLines = new LineInfos();
    private final List<BlameChunk> mChunks = new ArrayList<BlameChunk>();
    private final FileHistory hist;
    private Revision mRevision;

    public Annotator(FileHistory hist, ChangeTree aTree) {
        this.mTree = aTree;
        this.hist = hist;
    }

    public Revision getRevision() {
        return this.mRevision;
    }

    public void annotate(Revision aRev) {
        this.mRevision = aRev;
        List<Revision> ancestors = this.mTree.getAncestors(aRev);
        Revision r0 = ancestors.get(0);
        FileRevision info = this.hist.getRevision(r0.toString());
        int count = info.getLineCount();
        this.mLines.init(info, count);
        for (int i2 = 0; i2 < ancestors.size() - 1; ++i2) {
            Revision r1 = ancestors.get(i2);
            Revision r2 = ancestors.get(i2 + 1);
            this.annotateImpl(r1, r2);
        }
        BlameChunk last = null;
        int line = 0;
        for (LineInfo lineInfo : this.mLines) {
            FileRevision r2 = lineInfo.rev;
            int originalLine = lineInfo.origLineNumber;
            if (last == null) {
                last = new BlameChunk(r2, line, 0);
                this.mChunks.add(last);
            } else if (r2.getRevision().equals(last.getInfo().getRevision()) && last.getLength() < 8000) {
                last.incLength(1);
            } else {
                last = new BlameChunk(r2, line, originalLine);
                this.mChunks.add(last);
            }
            ++line;
        }
    }

    private void annotateImpl(Revision r1, Revision r2) {
        boolean reverse = false;
        RevisionEdge edge = new RevisionEdge(r1, r2);
        ChunkList hunks = this.mTree.getChange(edge);
        if (hunks == null) {
            reverse = true;
            edge = new RevisionEdge(r2, r1);
            hunks = this.mTree.getChange(edge);
        }
        assert (hunks != null) : "could not find edge between " + r1 + " and " + r2 + ", edge was " + edge;
        this.mLines.currentRev = this.hist.getRevision(r2.toString());
        hunks.applyHunksToSpans(this.mLines, reverse);
    }

    public List<BlameChunk> getChunks() {
        return this.mChunks;
    }

    private static class LineInfo {
        final FileRevision rev;
        final int origLineNumber;

        public LineInfo(FileRevision rev, int origLineNumber) {
            this.rev = rev;
            this.origLineNumber = origLineNumber;
        }
    }

    private static class LineInfos
    implements LineInfoListener,
    Iterable<LineInfo> {
        List<LineInfo> lines = new LinkedList<LineInfo>();
        FileRevision currentRev;

        private LineInfos() {
        }

        @Override
        public void addLines(int offset, Chunk chunk) {
            int line = chunk.getLine() + offset - 1;
            for (int j2 = 0; j2 < chunk.getCount(); ++j2) {
                this.lines.add(line + j2, new LineInfo(this.currentRev, line + j2));
            }
        }

        @Override
        public void removeLines(int offset, Chunk chunk) {
            int line = chunk.getLine() + offset - 1;
            this.lines.subList(line, line + chunk.getCount()).clear();
        }

        public void init(FileRevision info, int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                this.lines.add(new LineInfo(info, i2));
            }
        }

        @Override
        public Iterator<LineInfo> iterator() {
            return this.lines.iterator();
        }
    }
}

